<?php
/*
 * Template Name: Template Blog
 * Description: A Page Template with a Page Builder design.
 */
$hostino_redux_demo = get_option('redux_demo'); 
get_header();
?>
<div id="page-head" class="container-fluid inner-page">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <div class="page-title">
                    <?php echo esc_html__( 'Blog & News', 'hostino' );?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
    $i = 0;
    $args = array(    
                'paged' => $paged,
                'post_type' => 'post',
                );
            $wp_query = new WP_Query($args);
    while ($wp_query -> have_posts()): $wp_query -> the_post();
    $linkfb = get_post_meta(get_the_ID(),'_cmb_blog_linkfb', true);
    $linktw = get_post_meta(get_the_ID(),'_cmb_blog_linktw', true);
    $linkpi = get_post_meta(get_the_ID(),'_cmb_blog_linkpi', true);
    if( $i == 0 ){
  ?>
<div id="recent-article" class="container-fluid">
    <div class="custom-bg"></div>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="img-holder">
                  <?php if ( has_post_thumbnail() ) { ?>
                    <?php the_post_thumbnail(); ?>
                  <?php }?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="article-summary">
                    <div class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></div>
                    <div class="article-date"><?php the_time(get_option( 'date_format' ));?></div>
                    <div class="article-text">
                      <?php if(isset($hostino_redux_demo['blogfist_excerpt'])){?>
                        <?php echo esc_attr(hostino_excerpt($hostino_redux_demo['blogfist_excerpt'])); ?>
                        <?php }else{?>
                        <?php echo esc_attr(hostino_excerpt(200));
                        }
                      ?>
                    </div>
                    <div class="article-links">
                        <div class="col-xs-6">
                            <div class="readmore-holder">
                                <a href="<?php the_permalink();?>" class="readmore-button">
                                  <?php if(isset($hostino_redux_demo['read_more_fist'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['read_more_fist']));?>
                                    <?php }else{?>
                                      <?php echo esc_html__( 'Read Full Article', 'hostino' );
                                    }
                                  ?>
                                </a>
                            </div>
                        </div>
                        <div class="col-xs-6">
                            <div class="socialshare-holder">
                              <?php
                              if ($linkfb != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linkfb));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            <?php
                              if ($linktw != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linktw));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            <?php
                              if ($linkpi != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linkpi));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } $i++; endwhile; ?>
<div id="articles" class="container-fluid">
  <div class="container">
      <div class="row">
          <?php
            $i = 0;
            $args = array(    
                'paged' => $paged,
                'post_type' => 'post',
                );
            $wp_query = new WP_Query($args);
            while ($wp_query -> have_posts()): $wp_query -> the_post();
            $linkfb = get_post_meta(get_the_ID(),'_cmb_blog_linkfb', true);
            $linktw = get_post_meta(get_the_ID(),'_cmb_blog_linktw', true);
            $linkpi = get_post_meta(get_the_ID(),'_cmb_blog_linkpi', true);
            if( $i > 0 ){
          ?>
          <div class="col-sm-6 col-md-4">
              <div class="article-summary">
                  <div class="article-img">
                    <?php if ( has_post_thumbnail() ) { ?>
                      <?php the_post_thumbnail(); ?>
                    <?php }?>
                  </div>
                  <div class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></div>
                  <div class="article-date"><?php the_time(get_option( 'date_format' ));?></div>
                  <div class="article-text">
                    <?php if(isset($hostino_redux_demo['blog_excerpt'])){?>
                      <?php echo esc_attr(hostino_excerpt($hostino_redux_demo['blog_excerpt'])); ?>
                      <?php }else{?>
                      <?php echo esc_attr(hostino_excerpt(30));
                      }
                    ?>
                  </div>
                  <div class="article-links">
                      <div class="col-xs-6">
                          <div class="socialshare-holder">
                              <?php
                              if ($linkfb != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linkfb));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            <?php
                              if ($linktw != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linktw));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            <?php
                              if ($linkpi != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linkpi));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                          </div>
                      </div>
                      <div class="col-xs-6">
                          <div class="readmore-holder">
                              <a href="<?php the_permalink();?>" class="readmore-button">
                                <?php if(isset($hostino_redux_demo['read_more'])){?>
                                  <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['read_more']));?>
                                  <?php }else{?>
                                    <?php echo esc_html__( 'Read More', 'hostino' );
                                  }
                                ?>
                              </a>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
          <?php } $i++; endwhile; ?>
          <div class="col-md-12">
              <?php hostino_pagination();?>
          </div>
      </div>  
  </div>
</div>
<div id="greybg-info" class="container-fluid">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="text">
                  <?php if(isset($hostino_redux_demo['blog_fttext'])){?>
                    <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['blog_fttext']));?>
                    <?php }else{?>
                      <?php echo esc_html__( 'Whant to write about us?<br>Contact us today.', 'hostino' );
                    }
                  ?>
                </div>
                <a href="<?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['blog_ftlink']));?>" class="white-less-shadow-button" >
                  <?php if(isset($hostino_redux_demo['blog_ftbtn'])){?>
                    <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['blog_ftbtn']));?>
                    <?php }else{?>
                      <?php echo esc_html__( 'Contact us', 'hostino' );
                    }
                  ?>
                </a>
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
?>