<?php
$hostino_redux_demo = get_option('redux_demo'); 
get_header(); ?>
<div id="page-head" class="container-fluid inner-page">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <div class="page-title">
                  <?php
                      if ( is_day() ) :
                          printf( esc_html__( 'Daily Archives: %s', 'hostino' ), get_the_date() );

                      elseif ( is_month() ) :
                          printf( esc_html__( 'Monthly Archives: %s', 'hostino' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'hostino' ) ) );

                      elseif ( is_year() ) :
                          printf( esc_html__( 'Yearly Archives: %s', 'hostino' ), get_the_date( _x( 'Y', 'yearly archives date format', 'hostino' ) ) );

                      else :
                          esc_html_e( 'Archives', 'hostino' );

                      endif;
                  ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="articles" class="container-fluid">
  <div class="container">
      <div class="row">
        <div class="col-md-9">
          <?php
            while (have_posts()): the_post();
          ?>
            <div class="col-sm-12">
            <div class="article-summary">
              <?php if ( has_post_thumbnail() ) { ?>
                <div class="article-img">
                    <?php the_post_thumbnail(); ?>
                </div>
                <?php }?>
                <div class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a><?php if ( is_sticky() )
     echo '<span class="featured-post">' . esc_html__( 'Sticky Template', 'hostino' ) . '</span>';
     ?></div>
                <div class="article-date"><?php the_time(get_option( 'date_format' ));?></div>
                <div class="article-text">
                  <?php if(isset($hostino_redux_demo['blog_excerpt'])){?>
                    <?php echo esc_attr(hostino_excerpt($hostino_redux_demo['blog_excerpt'])); ?>
                    <?php }else{?>
                    <?php echo esc_attr(hostino_excerpt(30));
                    }
                  ?>
                </div>
                <div class="article-links">
                        <div class="readmore-holder">
                            <a href="<?php the_permalink();?>" class="readmore-button">
                              <?php if(isset($hostino_redux_demo['read_more'])){?>
                                <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['read_more']));?>
                                <?php }else{?>
                                  <?php echo esc_html__( 'Read More', 'hostino' );
                                }
                              ?>
                            </a>
                        </div>
                    </div>
                    <hr>  
            </div>
            </div>
            
          <?php endwhile; ?>
          <div class="col-md-12">
              <?php hostino_pagination();?>
          </div>
        </div>
        <div id="sidebar" class="col-md-3">
            <div class="widget-area">
                <?php get_sidebar();?>
            </div>
        </div>
      </div>  
  </div>
</div>
<?php
get_footer();
?>