<?php
$hostino_redux_demo = get_option('redux_demo');
//Custom fields:
require_once get_template_directory() . '/framework/widget/recent-post.php';
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/visual/shortcodes.php';
require_once get_template_directory() . '/visual/vc_shortcode.php';
//Theme Set up:
function hostino_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
	add_theme_support( 'custom-header' ); 
	add_theme_support( 'custom-background' );
	
    add_theme_support( 'post-thumbnails' );
    // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );
    // Switches default core markup for search form, comment form, and comments
    // to output valid HTML5.
    add_theme_support( "title-tag" );
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    //Post formats
    $lang = get_template_directory_uri() . '/languages';
    load_theme_textdomain('hostino', $lang);
    add_post_type_support( 'post', 'post-formats', array( 'audio',  'gallery', 'image', 'video' ) );
    add_post_type_support( 'portfolio', 'post-formats', array( 'gallery', 'image' ) );
    // This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
    'primary' => esc_html__('Primary Navigation Menu: Chosen menu in Home page, single, blog, pages ...', 'hostino'),
  ) );
    // This theme uses its own gallery styles.
	add_filter( 'use_default_gallery_style', '__return_false' );
}
add_action( 'after_setup_theme', 'hostino_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;



function hostino_theme_scripts_styles() {
  $hostino_redux_demo = get_option('redux_demo');;
  $protocol = is_ssl() ? 'https' : 'http';

        wp_enqueue_style( 'googlefont', 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800');
        //Template CSS Files
        wp_enqueue_style( 'bootstrap', get_template_directory_uri().'/css/bootstrap.min.css');
        wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/css/font-awesome.min.css');
        wp_enqueue_style( 'slick', get_template_directory_uri().'/css/slick.css');
        wp_enqueue_style( 'hostino-style', get_template_directory_uri().'/css/style.css');
        wp_enqueue_style( 'hostino', get_template_directory_uri().'/fonts/hostino.css');

        wp_enqueue_style( 'hostino-css', get_stylesheet_uri(), array(), '2016-08-27' );
        

  if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
  //Javascript 

    wp_enqueue_script("hostino-total", get_template_directory_uri()."/js/total.js",array(),false,true);
    wp_enqueue_script("bootstrap", get_template_directory_uri()."/js/bootstrap.min.js",array(),false,true);
    wp_enqueue_script("slick", get_template_directory_uri()."/js/slick.min.js",array(),false,true);
    wp_enqueue_script("hostino-main", get_template_directory_uri()."/js/main.js",array(),false,true);
    wp_enqueue_script("paper-full", get_template_directory_uri()."/js/paper-full.min.js",array(),false,true);
}
add_action( 'wp_enqueue_scripts', 'hostino_theme_scripts_styles' );

//Custom Excerpt Function
function hostino_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
}
// Widget Sidebar
function hostino_widgets_init() {
	register_sidebar( array(
        'name'          => esc_html__( 'Primary Sidebar', 'hostino' ),
        'id'            => 'sidebar-1',        
		'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'hostino' ),        
		'before_widget' => '<div id="%1$s" class="widget %2$s">',        
		'after_widget'  => '</div>',        
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>'
    ) );

    register_sidebar( array(
		'name'          => esc_html__( 'Footer One Widget Area', 'hostino' ),
		'id'            => 'footer-area-1',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'hostino' ),
		'before_widget' => '<div id="%1$s">',
		'after_widget'  => '</div>',
		'before_title'  => ' ',
		'after_title'   => ' ',
	) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer two Widget Area', 'hostino' ),
    'id'            => 'footer-area-2',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'hostino' ),
    'before_widget' => '<div id="%1$s">',
    'after_widget'  => '</div>',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer three Widget Area', 'hostino' ),
    'id'            => 'footer-area-3',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'hostino' ),
    'before_widget' => '<div id="%1$s">',
    'after_widget'  => '</div>',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Four Widget Area', 'hostino' ),
    'id'            => 'footer-area-4',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'hostino' ),
    'before_widget' => '<div id="%1$s">',
    'after_widget'  => '</div>',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
    register_sidebar( array(
    'name'          => esc_html__( 'Footer Social Widget Area', 'hostino' ),
    'id'            => 'footer-area-5',
    'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'hostino' ),
    'before_widget' => '<div id="%1$s">',
    'after_widget'  => '</div>',
    'before_title'  => ' ',
    'after_title'   => ' ',
  ) );
	
}
add_action( 'widgets_init', 'hostino_widgets_init' );
function hostino_add_class_previous($format){
  $format = str_replace('href=', 'class="icon-left-open-big" href=', $format);
  return $format;
}
function hostino_add_class_next($format){
  $format = str_replace('href=', 'class="icon-right-open-big" href=', $format);
  return $format;
}
add_filter('next_post_link', 'hostino_add_class_next');
add_filter('previous_post_link', 'hostino_add_class_previous');
//function tag widgets
function hostino_tag_cloud_widget($args) {
	$args['number'] = 0; //adding a 0 will display all tags
	$args['largest'] = 18; //largest tag
	$args['smallest'] = 11; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'hostino_tag_cloud_widget' );
function hostino_excerpt() {
  $hostino_redux_demo = get_option('redux_demo');;
  if(isset($hostino_redux_demo['blog_excerpt'])){
    $limit = $hostino_redux_demo['blog_excerpt'];
  }else if(isset($hostino_redux_demo['blogfist_excerpt'])){
    $limit = $hostino_redux_demo['blogfist_excerpt'];
  }else{
    $limit = 20;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt) >= $limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}


if ( !function_exists('hostino_pagination') ) {
function hostino_pagination($prev = '<span aria-hidden="true">&laquo;</span>', $next = '<span aria-hidden="true">&raquo;</span>', $pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }
    $pagination = array(
        'base'          => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
        'format'        => '',
        'current'       => max( 1, get_query_var('paged') ),
        'total'         => $pages,
        'prev_text' => $prev,
        'next_text' => $next,       
        'type'          => 'list',
        'end_size'      => 5,
        'mid_size'      => 5
);
    $return =  paginate_links( $pagination );
    echo str_replace( "<ul class='page-numbers'>", '<ul class="pagination">', $return );
}
}

//Get thumbnail url

function hostino_post_nav() {
    global $post;
    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );
    if ( ! $next && ! $previous )
        return;
    ?>
	<ul class="pager clearfix">
	  <li class="previous">
		<?php previous_post_link( '%link', _x( ' &larr; Older Item', 'Previous post link', 'hostino' ) ); ?>
	  </li>
	  <li class="next">
		<?php next_post_link( '%link', _x( 'Newer Item &rarr;', 'Next post link', 'hostino' ) ); ?>
	  </li>
	</ul>   
<?php
}
function hostino_search_form( $form ) {
    $form = '
        <div class="widget">
            <form action="'.esc_url(home_url('/')).'" class="search-form" method="post">
                <input class="form-control" placeholder="'.esc_html__( 'Search...', 'hostino' ).'" type="text" name="s">
            </form>
        </div>';
    return $form;
}
add_filter( 'get_search_form', 'hostino_search_form' );
//Custom comment List:

// Comment Form


function hostino_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>
        <div class="row" id="comment-id">
            <div class="col-sm-2">
                <?php echo get_avatar($comment,$size='100' ); ?>
            </div>
            <div class="col-sm-10">
                <h3 class="name"><?php printf(__('%s','hostino'), get_comment_author_link()) ?></h3>
                <?php the_time(get_option( 'date_format' ));?>
                <p class="desc"><?php comment_text() ?></p>
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div>
        </div>
        <hr>
<?php
}



add_action( 'wp_login_form', 'hostino_my_form_login' );
function hostino_my_form_login( $args = array() ) {
$defaults = array(
        'echo' => true,
        'redirect' => site_url( '/wp-admin' ), 
        'form_id' => 'loginform',
        'label_username' => esc_html__( 'Username' , 'hostino'),
        'label_password' => esc_html__( 'Password', 'hostino' ),
        'label_remember' => esc_html__( 'Remember Me', 'hostino' ),
        'label_log_in' => esc_html__( 'Sign in' , 'hostino'),
        'id_username' => 'user_login',
        'id_password' => 'user_pass',
        'id_email'    => 'email',
        'id_remember' => 'rememberme',
        'id_submit' => 'wp-submit',
        'remember' => true,
        'value_username' => '',
        'value_remember' => false,
);
$args = wp_parse_args( $args, apply_filters( 'login_form_defaults', $defaults ) );

$form = '<div class="modal fade" id="login" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content modal-popup">
                <a href="#" class="close-link"><i class="icon_close_alt2"></i></a>
                <form name="' . $args['form_id'] . '" id="'.$args['form_id'].'" action="' . esc_url( site_url( 'wp-login.php', 'login_post' ) ) . '" method="post" class="popup-form">
                    <input type="text" name="log" class="form-control form-hostino" placeholder="Username" id="'.esc_attr( $args['id_email'] ).'" value="' . esc_attr( $args['value_username'] ) . '">
                    <input type="text" name="pwd" class="form-control form-hostino" placeholder="Password" id="' . esc_attr( $args['id_password'] ) . '">
                    ' . apply_filters( 'login_form_middle', '', $args ) . '
                    <div class="checkbox-holder text-left">
                        <div class="checkbox">
                            <input type="checkbox" value="accept_1" id="check_1" name="check_1" />
                            <label for="check_1"><span>I Agree to the <strong>Terms &amp; Conditions</strong></span></label>
                        </div>
                    </div>
                    <button name="wp-submit" id="' . esc_attr( $args['id_submit'] ) . '" type="submit" class="btn btn-submit">Submit</button>
                    ' . apply_filters( 'login_form_bottom', '', $args ) . '
                </form>
            </div>
        </div>
    </div> ';

if ( $args['echo'] )
        echo $form;
else
        return $form;
    }



function hostino_custom_css_classes_for_vc_row_and_vc_column($class_string, $tag) {
    if($tag=='vc_row' || $tag=='vc_row_inner') {
        $class_string = str_replace('vc_row-fluid', '', $class_string);
    }
    if($tag=='vc_column' || $tag=='vc_column_inner') {
    $class_string = preg_replace('/vc_col-sm-12/', 'col-md-12', $class_string);
    $class_string = preg_replace('/vc_col-sm-6/', 'col-md-6', $class_string);
    $class_string = preg_replace('/vc_col-sm-4/', 'col-md-4', $class_string);
    $class_string = preg_replace('/vc_col-sm-3/', 'col-md-3', $class_string);
    $class_string = preg_replace('/vc_col-sm-5/', 'col-md-5', $class_string);
    $class_string = preg_replace('/vc_col-sm-7/', 'col-md-7', $class_string);
    $class_string = preg_replace('/vc_col-sm-8/', 'col-md-8', $class_string);
    $class_string = preg_replace('/vc_col-sm-9/', 'col-md-9', $class_string);
    $class_string = preg_replace('/vc_col-sm-10/', 'col-md-10', $class_string);
    $class_string = preg_replace('/vc_col-sm-11/', 'col-md-11', $class_string);
    $class_string = preg_replace('/vc_col-sm-1/', 'col-md-1', $class_string);
    $class_string = preg_replace('/vc_col-sm-2/', 'col-md-2', $class_string);
    }
    return $class_string;
}
// Filter to Replace default css class for vc_row shortcode and vc_column
add_filter('vc_shortcodes_css_class', 'hostino_custom_css_classes_for_vc_row_and_vc_column', 10, 2); 
// Add new Param in Row
if(function_exists('vc_add_param')){
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section Id', 'hostino'),
                              "param_name" => "ses_id",
                              "value" => "",
                              "description" => esc_html__("Section Id, Leave a blank do not show frontend.", "hostino"),   
    ));
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section Title', 'hostino'),
                              "param_name" => "ses_title",
                              "value" => "",
                              "description" => esc_html__("Title of Section, Leave a blank do not show frontend.", "hostino"),   
    ));
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section Sub Title', 'hostino'),
                              "param_name" => "ses_sub_title",
                              "value" => "",
                              "description" => esc_html__("Section Title, Leave a blank do not show frontend.", "hostino"),   
    ));
vc_add_param('vc_row',array(
                             'type' => 'dropdown',
                             'heading' => esc_html__( 'Chosen type row', 'hostino' ),
                             'param_name' => 'type_row',
                             'value' => array(
                                esc_html__( 'None Section', 'hostino' ) => 'type2',
                                esc_html__( 'Slider', 'hostino' ) => 'slider',
                                esc_html__( 'Features', 'hostino' ) => 'features',
                                esc_html__( 'Features 2', 'hostino' ) => 'features2',
                                esc_html__( 'Features More', 'hostino' ) => 'featuresmore',
                                esc_html__( 'Features More 2', 'hostino' ) => 'featuresmore2',
                                esc_html__( 'Pricing', 'hostino' ) => 'pricing',
                                esc_html__( 'Pricing domain', 'hostino' ) => 'pricingdomain',
                                esc_html__( 'Testimonials', 'hostino' ) => 'testimonials',
                                esc_html__( 'More Info', 'hostino' ) => 'moreinfo',
                                esc_html__( 'Goals', 'hostino' ) => 'goals',
                                esc_html__( 'team', 'hostino' ) => 'team',
                                esc_html__( 'Contact', 'hostino' ) => 'contact',
                                esc_html__( 'Blog', 'hostino' ) => 'blog',
                                esc_html__( 'Signin', 'hostino' ) => 'signin',
                                esc_html__( 'Signup', 'hostino' ) => 'signup',


                             ),
                             'description' => esc_html__( 'Select type row', 'hostino' )
      )); 

vc_add_param('vc_row',array(
                              "type" => "textarea_html",
                              "heading" => esc_html__('Section Content', 'hostino'),
                              "param_name" => "ses_content",
                              "value" => "",
                              "description" => esc_html__("Section Content, Leave a blank do not show frontend.", "hostino"),   
    ));
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section Text', 'hostino'),
                              "param_name" => "ses_text",
                              "value" => "",
                              "description" => esc_html__("Text button with block: focus", "hostino"),   
    )); 
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section Link', 'hostino'),
                              "param_name" => "ses_link",
                              "value" => "",
                              "description" => esc_html__("Link button with block: focus", "hostino"),   
    ));
vc_add_param('vc_row',array(
                              "type" => "textfield",
                              "heading" => esc_html__('Section button name', 'hostino'),
                              "param_name" => "ses_btname",
                              "value" => "",
                              "description" => esc_html__("button with block: focus", "hostino"),   
    ));
vc_add_param('vc_row',array(
                             'type' => 'attach_image',
                             'heading' => esc_html__( 'Image Background', 'hostino' ),
                             'param_name' => 'ses_image',
                             'value' => '',
                             'description' => esc_html__( 'Select image from media library to do your signature.', 'hostino' )
      ));
// Add new Param in Column  

}


/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'hostino_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function hostino_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
             // This is an example of how to include a plugin from a private repo in your theme.
         
    
        array(
            'name'      => esc_html__( 'Contact Form 7', 'hostino' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ),
        array(
            'name'               => esc_html__( 'WPBakery Visual Composer', 'hostino' ), // The plugin name.
            'slug'               => 'visualcomposer',
            'source'             => get_template_directory_uri() . '/framework/plugins/js_composer.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),     
    array(
            'name'      => 'One Click Demo Import',
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
    array(
            'name'               => esc_html__( 'WP Custom Register Login', 'hostino' ), // The plugin name.
            'slug'               => 'wp-custom-register-login',
            'source'             => get_template_directory_uri() . '/framework/plugins/wp-custom-register-login.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),  
    array(
            'name'               => esc_html__( 'Post Views Counter', 'hostino' ), // The plugin name.
            'slug'               => 'post-views-counter',
            'source'             => get_template_directory_uri() . '/framework/plugins/post-views-counter.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),
        array(
            'name'                     => esc_html__( 'hostino Common', 'hostino' ),
            'slug'                     => 'hostino-common',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/hostino-common.zip',
        )
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'hostino' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'hostino' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'hostino' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'hostino' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'hostino' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'hostino' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'hostino' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'hostino' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'hostino' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'hostino' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'hostino' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'hostino' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'hostino' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'hostino' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'hostino' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'hostino' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'hostino' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}

function hostino_import_files() {
    return array(
        array(
            'import_file_name'           => 'Demo Import Hostino',
            'import_file_url'            => 'http://shtheme.com/import/hostino/content.xml',
            'import_widget_file_url'     => 'http://shtheme.com/import/hostino/widgets.json',
            'import_preview_image_url'   => 'http://shtheme.com/import/hostino/Image-Preview.jpg',
            'import_notice'              => esc_html__( 'Import data example hostino', 'hostino' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'hostino_import_files' );




function hostino_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary Menu', 'primary' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'hostino_after_import_setup' );



?>