<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php
$hostino_redux_demo = get_option('redux_demo');
?>
  <head>
      <!-- Meta Tags -->
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <?php wp_head(); ?>
  </head>

  <body <?php body_class(); ?>>
        <nav id="mainNav" class="navbar navbar-default navbar-full">
            <div class="container container-nav">
            <div class="navbar-header">
                <button aria-expanded="false" type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand page-scroll" href="<?php echo esc_url(home_url('/')); ?>">
                    <?php if(isset($hostino_redux_demo['logo']['url']) && $hostino_redux_demo['logo']['url'] != ''){?>
                        <img src="<?php echo esc_url($hostino_redux_demo['logo']['url']);?>" alt="Hostino">
                    <?php }else{ ?> 
                        <img class="logo" id="logo" src="<?php echo get_template_directory_uri();?>/images/logo.png" alt="Hostino">
                    <?php } ?>
                    
                </a>
            </div>
            <div role="main" aria-expanded="false" class="navbar-collapse collapse" id="bs">
                <?php 
                  wp_nav_menu( 
                  array( 
                        'theme_location' => 'primary',
                        'container' => '',
                        'menu_class' => '', 
                        'menu_id' => '',
                        'menu'            => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'echo'            => true,
                         'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                         'walker'            => new hostino_wp_bootstrap_navwalker(),
                        'before'          => '',
                        'after'           => '',
                        'link_before'     => '',
                        'link_after'      => '',
                        'items_wrap'      => '<ul class="nav navbar-nav navbar-right %2$s">%3$s</ul>',
                        'depth'           => 0,        
                    )
                 ); ?>
            </div>
        </div>
    </nav>