<?php
$hostino_redux_demo = get_option('redux_demo'); 
get_header(); ?>
<div id="page-head" class="container-fluid inner-page">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <div class="page-title">
                  <?php printf( esc_html__( 'Taxonomy Type: %s', 'hostino' ), single_cat_title( '', false ) ); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="articles" class="container-fluid">
  <div class="container">
      <div class="row">
        <div class="col-md-9">
          <?php
            while (have_posts()): the_post();
            $linkfb = get_post_meta(get_the_ID(),'_cmb_blog_linkfb', true);
            $linktw = get_post_meta(get_the_ID(),'_cmb_blog_linktw', true);
            $linkpi = get_post_meta(get_the_ID(),'_cmb_blog_linkpi', true);
          ?>
            <div class="col-sm-12">
            <div class="article-summary">
                <div class="article-img">
                  <?php if ( has_post_thumbnail() ) { ?>
                    <?php the_post_thumbnail(); ?>
                  <?php }?>
                </div>
                <div class="article-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></div>
                <div class="article-date"><?php the_time(get_option( 'date_format' ));?></div>
                <div class="article-text">
                  <?php if(isset($hostino_redux_demo['blog_excerpt'])){?>
                    <?php echo esc_attr(hostino_excerpt($hostino_redux_demo['blog_excerpt'])); ?>
                    <?php }else{?>
                    <?php echo esc_attr(hostino_excerpt(30));
                    }
                  ?>
                </div>
                <div class="article-links">
                    <div class="col-xs-6">
                        <div class="socialshare-holder">
                            <?php
                              if ($linkfb != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linkfb));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            <?php
                              if ($linktw != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linktw));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                            <?php
                              if ($linkpi != '') { ?>
                                <a href="<?php echo htmlspecialchars_decode(esc_attr($linkpi));?>"><i class="fa fa-facebook"></i></a>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="readmore-holder">
                            <a href="<?php the_permalink();?>" class="readmore-button">
                              <?php if(isset($hostino_redux_demo['read_more'])){?>
                                <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['read_more']));?>
                                <?php }else{?>
                                  <?php echo esc_html__( 'Read More', 'hostino' );
                                }
                              ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            </div>
          <?php endwhile; ?>
          <div class="col-md-12">
              <?php hostino_pagination();?>
          </div>
        </div>
        <div id="sidebar" class="col-md-3">
            <div class="widget-area">
                <?php get_sidebar();?>
            </div>
        </div>
      </div>  
  </div>
</div>
<div id="greybg-info" class="container-fluid">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="text text-width2">
                  <?php if(isset($hostino_redux_demo['blog_fttext'])){?>
                    <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['blog_fttext']));?>
                    <?php }else{?>
                      <?php echo esc_html__( 'Whant to write about us? Contact us today.', 'hostino' );
                    }
                  ?>
                </div>
                <a href="<?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['blog_ftlink']));?>" class="white-less-shadow-button" >
                  <?php if(isset($hostino_redux_demo['blog_ftbtn'])){?>
                    <?php echo htmlspecialchars_decode(esc_attr($hostino_redux_demo['blog_ftbtn']));?>
                    <?php }else{?>
                      <?php echo esc_html__( 'Contact us', 'hostino' );
                    }
                  ?>
                </a>
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
?>