<?php
/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       http://www.daffodilsw.com/
 * @since      1.0.0
 *
 * @package    Wp_Custom_Register_Login
 * @subpackage Wp_Custom_Register_Login/public/partials
 */

?>

<div class="col-sm-5 form-holder">
    <div class="signin-signup-form">
        <div class="form-title">Sign up for new account</div>
            <?php
            $wpcrl_form_settings = get_option('wpcrl_form_settings');
            $form_heading = empty($wpcrl_form_settings['wpcrl_signup_heading']) ? 'Register' : $wpcrl_form_settings['wpcrl_signup_heading'];

            // check if the user already login
            if (!is_user_logged_in()) :

                ?>
                <form name="wpcrlRegisterForm" id="wpcrlRegisterForm" method="post">

                    <div id="wpcrl-reg-loader-info" class="wpcrl-loader" style="display:none;">
                        <img src="<?php echo plugins_url('images/ajax-loader.gif', dirname(__FILE__)); ?>"/>
                        <span><?php _e('Please wait ...', $this->plugin_name); ?></span>
                    </div>
                    <div id="wpcrl-register-alert" class="alert alert-danger" role="alert" style="display:none;"></div>
                    <div id="wpcrl-mail-alert" class="alert alert-danger" role="alert" style="display:none;"></div>
                    <?php if ($token_verification): ?>
                        <div class="alert alert-info" role="alert"><?php _e('Your account has been activated, you can login now.', $this->plugin_name); ?></div>
                    <?php endif; ?>
                    <div class="form-text">
                        <input type="text"  name="wpcrl_username" id="wpcrl_username" placeholder="UserName">
                    </div>
                    <div class="form-text">
                        <input type="text" name="wpcrl_email" id="wpcrl_email" placeholder="E-mail Address">
                    </div>
                    <div class="form-text">
                        <input type="password" name="wpcrl_password" id="wpcrl_password" placeholder="Password" >
                    </div>
                    <div class="form-text">
                        <input type="password" name="wpcrl_password2" id="wpcrl_password2" placeholder="Confirm Password" >
                    </div>
                    <div class="form-text text-holder">
                        <span class="text-only">Preferred method of payment.</span>
                        <input type="radio" name="pmethod" class="hno-radiobtn" id="rad1"><label for="rad1">Paypal</label>
                        <input type="radio" name="pmethod" class="hno-radiobtn" id="rad2"><label for="rad2">Credit Card</label>
                    </div>
                    

                    <input type="hidden" name="wpcrl_current_url" id="wpcrl_current_url" value="<?php echo get_permalink(); ?>" />
                    <input type="hidden" name="redirection_url" id="redirection_url" value="<?php echo get_permalink(); ?>" />

                    <?php
                    // this prevent automated script for unwanted spam
                    if (function_exists('wp_nonce_field'))
                        wp_nonce_field('wpcrl_register_action', 'wpcrl_register_nonce');

                    ?>
                    <div class="form-button">
                        <button id="submit" type="submit" class="btn btn-default">Sign up <i class="hno hno-arrow-right"></i></button>
                    </div>
                </form>
                <?php
            else:
                $current_user = wp_get_current_user();
                $logout_redirect = (empty($wpcrl_form_settings['wpcrl_logout_redirect']) || $wpcrl_form_settings['wpcrl_logout_redirect'] == '-1') ? '' : $wpcrl_form_settings['wpcrl_logout_redirect'];

                echo 'Logged in as <strong>' . ucfirst($current_user->user_login) . '</strong>. <a href="' . wp_logout_url(get_permalink($logout_redirect)) . '">Log out ? </a>';
            endif;

            ?>
    </div>
</div>
