<?php

defined('ABSPATH') or die('No script kiddies please!');
/*
  Plugin Name: Themographics Core
  Plugin URI: http://themographics.com/
  Description: Themographics Framework for custom posts and customization.
  Version: 1.0
  Author: ThemoGraphics
  Author URI: http://themeforest.net/user/themographics
  License: GPL2
 */

if (!class_exists('Themographics_Core')) {

    class Themographics_Core {

        public $plugin_url;
        public $plugin_dir;

        public function __construct() {
            $this->plugin_url = plugin_dir_url(__FILE__);
            $this->plugin_dir = plugin_dir_path(__FILE__);

            require_once('core/class-core.php');
            require_once('core/class-functions.php');

            //Post Types
            $dir = $this->plugin_dir;
            $scan_PostTypes = glob("$dir/core/post-types/*");
            foreach ($scan_PostTypes as $filename) {
                @include $filename;
            }

            //Hooks
            require_once('hooks/hooks.php');

            //Shortcodes
            require_once('shortcodes/class-slider.php');

            //Enqueue Scripts
            add_action('admin_enqueue_scripts', array(&$this, 'tg_enqueue_scripts'));
            add_action('wp_enqueue_scripts', array(&$this, 'tg_enqueue_fronetend_scripts'));


            //Add Templates
            add_filter('template_include', array(&$this, 'tg_templates'));
        }

        /**
         * @PLugin Scripts
         * @return {}
         */
        public function tg_enqueue_scripts() {
            wp_enqueue_media();
            wp_enqueue_script('jquery', 'media-upload', 'jquery-ui-slide');

            wp_enqueue_script('tg_core_script', plugins_url('/js/functions.js', __FILE__), '', '', true);

            if (is_admin()) {
                wp_enqueue_script('tg_functions_script', plugins_url('/core/assets/js/admin_functions.js', __FILE__), '', '', true);
                wp_enqueue_style('vc-icon-picker-flaticon-css', plugins_url('/extend_vc/fonts/flaticon/css/flaticon.css', __FILE__));
            }
        }

        /**
         * @Plugin Scripts
         * @return {}
         */
        public function tg_enqueue_fronetend_scripts() {
            wp_enqueue_script('tg_core_script', plugins_url('/js/functions.js', __FILE__), '', '', true);
        }

        /**
         * @Plugin Scripts
         * @return {}
         */
        public static function tg_enqueue_gmap3() {
            wp_enqueue_script('jquery-goolge-places', 'http://maps.google.com/maps/api/js?sensor=false&libraries=places', '', '', true);
            wp_enqueue_script('tg_gmap3_script', plugins_url('/js/gmap3.min.js', __FILE__), '', '', true);
        }

        /**
         *
         * @PLugin URl
         */
        public static function plugin_url() {
            return plugin_dir_url(__FILE__);
        }

        /**
         *
         * @Plugin Images Path
         */
        public static function plugin_img_url() {
            return plugin_dir_url(__FILE__);
        }

        /**
         *
         * @Plugin Directory URL
         */
        public static function plugin_dir() {
            return plugin_dir_path(__FILE__);
        }

        /**
         *
         * @Plugin Activation
         */
        public static function activate() {
            //do something
        }

        /**
         *
         * @Plugin deactivation
         */
        public static function deactivate() {
            //do something
        }

        /**
         *
         * @ Include Template
         */
        public function tg_templates($single_template) {
            global $post;
            $single_path = dirname(__FILE__);

            if (get_post_type() == 'tg_projects') {
                if (is_single()) {
                    $single_template = plugin_dir_path(__FILE__) . '/templates/single-projects.php';
                }
            } 
             

            return $single_template;
        }

    }

    new Themographics_Core();
    register_activation_hook(__FILE__, array('Themographics_Core', 'activate'));
    register_deactivation_hook(__FILE__, array('Themographics_Core', 'deactivate'));
}
