<?php
/**
 * File Type: Slider
 */
if( ! class_exists('TG_Slider') ) {
	
	class TG_Slider {
	
		public function __construct() {
			global $pagenow;
			add_action('init', array(&$this, 'init_slider'));
			add_filter('manage_tg_slider_posts_columns', array(&$this, 'sliders_columns_add'));
			add_action('manage_tg_slider_posts_custom_column', array(&$this, 'sliders_columns'),10, 2);						
		}
		
		/**
		 * @Init Post Type
		 * @return {post}
		 */
		public function init_slider(){
			$this->prepare_post_type();
		}
		
		/**
		 * @Prepare Post Type
		 * @return {}
		 */
		public function prepare_post_type(){
			$labels = array(
				'name' 				 => esc_html__( 'TG Sliders', 'themographics_core' ),
				'all_items'			 => esc_html__( 'Sliders', 'themographics_core' ),
				'singular_name'      => esc_html__( 'Sliders', 'themographics_core' ),
				'add_new'            => esc_html__( 'Add Slider', 'themographics_core' ),
				'add_new_item'       => esc_html__( 'Add New Slider', 'themographics_core' ),
				'edit'               => esc_html__( 'Edit', 'themographics_core' ),
				'edit_item'          => esc_html__( 'Edit Slider', 'themographics_core' ),
				'new_item'           => esc_html__( 'New Slider', 'themographics_core' ),
				'view'               => esc_html__( 'View Slider', 'themographics_core' ),
				'view_item'          => esc_html__( 'View Slider', 'themographics_core' ),
				'search_items'       => esc_html__( 'Search Slider', 'themographics_core' ),
				'not_found'          => esc_html__( 'No Slider found', 'themographics_core' ),
				'not_found_in_trash' => esc_html__( 'No Slider found in trash', 'themographics_core' ),
				'parent'             => esc_html__( 'Parent Slider', 'themographics_core' ),
			);
			$args = array(
				'labels'			  => $labels,
				'description'         => esc_html__( 'This is where you can add new Slider', 'themographics_core' ),
				'public'              => true,
				'supports'            => array( 'title'),
				'show_ui'             => true,
				'capability_type'     => 'post',
				'map_meta_cap'        => true,
				'publicly_queryable'  => true,
				'exclude_from_search' => false,
				'hierarchical'        => false,
				'menu_position' 	  => 10,
				'rewrite'			  => array('slug' => 'tg_slider', 'with_front' => true),
				'query_var'           => false,
				'has_archive'         => 'false',
			); 
			register_post_type( 'tg_slider' , $args );
			
		}
		
		/**
		 * @Prepare Columns
		 * @return {post}
		 */
		public function sliders_columns_add($columns) {
			unset($columns['date']);
			$columns['shortcode'] 		= esc_html__('Shortcode','themographics_core');
		 
  			return $columns;
		}
		
		/**
		 * @Get Columns
		 * @return {}
		 */
		public function sliders_columns($name) {
			global $post;
			$tg_shortcode		= get_post_meta($post->ID,'tg_shortcode',true);
			
			switch ($name) {
				case 'shortcode':
					echo TG_CoreBase::tg_esc_specialchars( $tg_shortcode );
				break;		
				
			}
		}
	}
	
  	new TG_Slider();	
}