<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package Dexterity
 */
get_header();
?>
<?php
if (!function_exists('fw_get_db_settings_option')) {
    $search_text = esc_html__('Perhaps searching can help.', 'dexterity');
    $title = esc_html__('Oops Page Not Found!', 'dexterity');
    $sub_title = esc_html__('Something Went Wrong', 'dexterity');
    $message = esc_html__('We are really sorry but the page you requested is missing.', 'dexterity');
} else {
    $search_text = fw_get_db_settings_option('search_text');
    $title = fw_get_db_settings_option('404_title');
    $sub_title = fw_get_db_settings_option('404_sub_title');
    $message = fw_get_db_settings_option('404_message');
}
?>
<div class="tg-relativepostion tg-haslayout">
    <div class="tg-errormessage">
        <div class="col-lg-6 col-md-5 col-sm-12 col-xs-12 pull-left">
            <div class="row">
                <div class="tg-error tg-haslayout">
                    <h2>4<span class="icon-glasses23"></span>4</h2>
                </div>
            </div>
        </div>
        <div class="tg-error-content tg-haslayout">
            <div class="tg-displaytable">
                <div class="tg-displaytablecell">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-6 col-md-7 col-sm-12 col-xs-12 pull-right">
                                <div class="tg-heading-border">
                                    <?php if (isset($title) && !empty($title)) { ?>
                                        <h2><?php echo force_balance_tags($title); ?></h2>
                                    <?php } ?>
                                    <?php if (isset($sub_title) && !empty($sub_title)) { ?>
                                        <h3><?php echo force_balance_tags($sub_title); ?></h3>
                                    <?php } ?>
                                </div>
                                <?php if (isset($message) && !empty($message)) { ?>
                                    <div class="tg-description">
                                        <p><?php echo force_balance_tags($message); ?></p>
                                    </div>
                                <?php } ?>
                                <div class="tg-404search tg-haslayout">
                                    <?php if (isset($search_text) && !empty($search_text)) { ?>
                                        <div class="tg-heading-border">
                                            <h3><?php echo force_balance_tags($search_text); ?></h3>
                                        </div>
                                    <?php } ?>
                                    <form class="form-search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                                        <fieldset>
                                            <input type="search" placeholder="<?php esc_attr_e('Search..', 'dexterity'); ?>"  name="s" class="form-control" value="<?php echo get_search_query(); ?>">
                                        </fieldset>
                                        <button class="tg-btn" type="submit"><?php esc_attr_e('Send', 'dexterity'); ?></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
