<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package Mechanico
 */
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
    return;
}

/* ----------------------------------------------------------------------- */
/* 	Display Comments
  /*----------------------------------------------------------------------- */

    if (!function_exists('dexterity_comments')) {

        function dexterity_comments($comment, $args, $depth) {
            $GLOBALS['comment'] = $comment;
            $args['reply_text'] = 'Reply';

            $user_id = get_the_author_meta('ID');
            $user_url = get_author_posts_url($user_id);
            $user_avatar_display = get_the_author_meta('user_avatar_display', $user_id);
            ?>
            <li <?php echo str_replace('comment', '', comment_class('comment-entry clearfix', '', '', false)); ?> id="comment-<?php comment_ID(); ?>">
                <div  class="tg-commenter">
                    <figure class="tg-commenter-img">
                       <a href="<?php echo esc_url($user_url); ?>">
							<?php
								if (isset($user_avatar_display) && !empty($user_avatar_display) && $user_avatar_display != '') {
									echo '<img src="' . esc_url($user_avatar_display) . '" alt="'.esc_attr__('Author Avatar','dexterity').'">';
								} else {
									echo get_avatar($user_id, '','','',array('width'=>140,'height'=>102));
								}
							?>
						</a>
                    </figure>
                    <div class="tg-commenter-info">
                        <div class="tg-comment-head tg-haslayout">
                            <div class="tg-comment-head-left pull-left">
                                <time datetime="2016-03-15 12:25"><?php comment_date('M d, Y'); ?></time>
                                <div class="tg-heading-border">
                                    <h3><?php the_author(); ?></h3>
                                </div>
                            </div>
                            <div class="tg-comment-head-left pull-right">
                                <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                            </div>
                        </div>
                        <div class="tg-description">
                            <p>
								<?php
									$comment_text = get_comment_text();
									echo wp_kses(
											$comment_text,
											// Only allow <a>, <strong>, and <em> tags
											array(
										'a' => array(
											// Here, we whitelist 'href' and 'title' attributes - nothing else allowed!
											'href' => array(),
											'title' => array()
										),
										'br' => array(),
										'em' => array(),
										'strong' => array()
											)
									);
								?>
							</p>
                        </div>
                    </div>
                </div>

            <?php
        }

    }

    //comments reply and edit

    function format_comment($comment, $args, $depth) {
        $GLOBALS['comment'] = $comment;
        ?>
        <li>
			<div  class="tg-commenter">
                    <figure class="tg-commenter-img">
                       <a href="<?php echo esc_url($user_url); ?>">
							<?php
								if (isset($user_avatar_display) && !empty($user_avatar_display) && $user_avatar_display != '') {
									echo '<img src="' . esc_url($user_avatar_display) . '" alt="'.esc_attr__('Author Avatar','dexterity').'">';
								} else {
									echo get_avatar($user_id, '','','',array('width'=>140,'height'=>102));
								}
							?>
						</a>
                    </figure>
                    <div class="tg-commenter-info">
                        <div class="tg-comment-head tg-haslayout">
                            <div class="tg-comment-head-left pull-left">
                                <time datetime="2016-03-15 12:25"><?php comment_date('M d, Y'); ?></time>
                                <div class="tg-heading-border">
                                    <h3><?php the_author(); ?></h3>
                                </div>
                            </div>
                            <div class="tg-comment-head-left pull-right">
                                <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                            </div>
                        </div>
                        <div class="tg-description">
                            <p>
								<?php
									$comment_text = get_comment_text();
									echo wp_kses(
											$comment_text,
											// Only allow <a>, <strong>, and <em> tags
											array(
										'a' => array(
											// Here, we whitelist 'href' and 'title' attributes - nothing else allowed!
											'href' => array(),
											'title' => array()
										),
										'br' => array(),
										'em' => array(),
										'strong' => array()
											)
									);
								?>
							</p>
                        </div>
                    </div>
                </div>
			
			<?php if ($comment->comment_approved == '0') : ?>
				<em><?php esc_html_e('Your comment is awaiting moderation.', 'dexterity') ?></em><br />
			<?php endif; ?>
		<?php } ?>
			
    	<?php if (have_comments()) : ?>
			<div id="tg-comments" class="tg-comments tg-haslayout">
				<div class="tg-heading-border">
					<h3><?php comments_number(('0  Comments'), ('1  Comment'), ('% Comments')); ?></h3>
				</div>
				<ul class="tg-comment tg-haslayout">
					<?php wp_list_comments(array('callback' => 'dexterity_comments')); ?>
				</ul>
				<?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
					<?php previous_comments_link(esc_html__('&larr; Older Comments', 'dexterity')); ?>
					<?php next_comments_link(esc_html__('Newer Comments &rarr;', 'dexterity')); ?>
				<?php endif; ?>
			</div>
        <?php endif;?>
<div class="tg-post-comment-form tg-haslayout">
	<?php
    global $aria_req, $user_identity, $commenter;
    ob_start();
    comment_form(array(
        'fields' => apply_filters(
			'comment_form_default_fields', array(
				'first_name' => '
					<div class="col-md-4 col-sm-6 col-xs-12"><div class="form-group">' . '<input class="form-control" id="author" placeholder="'.esc_attr__('Name','dexterity').'" name="author" type="text" value="' .
				esc_attr($commenter['comment_author']) . '" size="30"' . $aria_req . ' />' .
				'</div></div>'
				,
				'phone' => '
					<div class="col-md-4 col-sm-6 col-xs-12"><div class="form-group">' . '<input class="form-control" id="phone" placeholder="'.esc_attr__('Phone','dexterity').'" name="phone" type="text" value="' .
				esc_attr($commenter['comment_author_phone']) . '" size="30"' . $aria_req . ' />' .
				'</div></div>'
				,
				'email' => '<div class="col-md-4 col-sm-6 col-xs-12"><div class="form-group">' . '<input class="form-control" id="email-address" placeholder="'.esc_attr__('Email','dexterity').'" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) .
				'" size="30"' . $aria_req . ' />' .
				'</div></div>',
				)
        ),
        'comment_field' => '<div class="col-xs-12"><div class="form-group">' .
        '<textarea class="form-control" name="comment" placeholder="'.esc_attr__('Message','dexterity').'" rows="4"></textarea>' .
        '</div></div>',
        'logged_in_as' => '<div class="col-sm-12 comment-logout"><div class="form-group">' . sprintf('Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', admin_url('profile.php'), $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink()))) . '</div></div>',
        'notes' => '',
        'comment_notes_before' => '',
        'comment_notes_after' => '',
        'id_form' => 'reply-form',
        'id_submit' => 'tg-btn',
        'class_form' => 'tg-form-comment tg-haslayout row',
        'class_submit' => 'tg-btn',
        'name_submit' => 'submit',
        'title_reply' => esc_html__('Leave your post', 'dexterity'),
        'title_reply_before' => '<div class="tg-heading-border"><h3>',
        'title_reply_after' => '</h3></div>',
        'cancel_reply_before' => '<span>',
        'cancel_reply_after' => '</span>',
        'cancel_reply_link' => esc_html__('Cancel reply', 'dexterity'),
        'label_submit' => esc_html__('Send', 'dexterity'),
        'submit_button' => '<input name="%1$s" type="submit" id="%2$s" class="tg-btn" value="%4$s" />',
        'submit_field' => '<div class="col-sm-3">%1$s %2$s</div>',
        'format' => 'xhtml',
    ));

    echo ob_get_clean();
    ?>
</div>
