<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
?>
<div class="sc-contatform">
    <?php if (isset($atts['form_title']) && !empty($atts['form_title'])) { ?>
        <div class="tg-heading-border">
            <h3><?php echo esc_attr($atts['form_title']); ?></h3>
        </div>
    <?php } ?>
    <div class="contact_wrap_pg">
        <div class="message_contact"></div>
        <form class="tg-form-contact tg-haslayout contact_form">
            <fieldset>
                <?php wp_nonce_field('dexterity_submit_contact', 'contact_security'); ?>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <input  type="text" name="username" placeholder="<?php esc_html_e('Full Name', 'dexterity'); ?>" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <input type="email" name="useremail" placeholder="<?php esc_html_e('Email', 'dexterity'); ?>" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <input type="text" name="userphone" placeholder="<?php esc_html_e('Phone Number', 'dexterity'); ?>" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <input type="url" name="website" placeholder="<?php esc_html_e('Website', 'dexterity'); ?>" class="form-control">
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="form-group">
                            <textarea  name="description" placeholder="<?php esc_html_e('Message', 'dexterity'); ?>" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <button class="tg-btn contact_now_pg"><?php esc_html_e('Send', 'dexterity'); ?></button>
                    </div>
                </div>
            </fieldset>
        </form>
    </div>
</div>
