<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'image_frame' => array(
        'type' => 'switch',
        'value' => 'on',
        'attr' => array(),
        'label' => esc_html__('Image Frame', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
        'left-choice' => array(
            'value' => 'off',
            'label' => esc_html__('Off', 'dexterity'),
        ),
        'right-choice' => array(
            'value' => 'on',
            'label' => esc_html__('ON', 'dexterity'),
        ),
    ),
    'image' => array(
        'type' => 'upload',
        'label' => esc_html__('Choose Image', 'dexterity'),
        'desc' => esc_html__('Either upload a new, or choose an existing image from your media library', 'dexterity')
    ),
    'size' => array(
        'type' => 'group',
        'options' => array(
            'width' => array(
                'type' => 'text',
                'label' => esc_html__('Width', 'dexterity'),
                'desc' => esc_html__('Set image width', 'dexterity'),
                'value' => 300
            ),
            'height' => array(
                'type' => 'text',
                'label' => esc_html__('Height', 'dexterity'),
                'desc' => esc_html__('Set image height', 'dexterity'),
                'value' => 200
            )
        )
    ),
    'image-link-group' => array(
        'type' => 'group',
        'options' => array(
            'link' => array(
                'type' => 'text',
                'label' => esc_html__('Image Link', 'dexterity'),
                'desc' => esc_html__('Where should your image link to?', 'dexterity')
            ),
            'target' => array(
                'type' => 'switch',
                'label' => esc_html__('Open Link in New Window', 'dexterity'),
                'desc' => esc_html__('Select here if you want to open the linked page in a new window', 'dexterity'),
                'right-choice' => array(
                    'value' => '_blank',
                    'label' => esc_html__('Yes', 'dexterity'),
                ),
                'left-choice' => array(
                    'value' => '_self',
                    'label' => esc_html__('No', 'dexterity'),
                ),
            ),
        )
    )
);