<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'heading' => array(
        'label' => esc_html__('Heading', 'dexterity'),
        'desc' => esc_html__('Enter The Project Heading Here.', 'dexterity'),
        'type' => 'text'
    ),
    'project_description' => array(
        'label' => esc_html__('Short Description', 'dexterity'),
        'desc' => esc_html__('Enter The Project Description Here.', 'dexterity'),
        'type' => 'textarea'
    ),
    'categories' => array(
        'type' => 'multi-select',
        'label' => esc_html__('Select Categories', 'dexterity'),
        'population' => 'taxonomy',
        'source' => 'project-category',
        'desc' => esc_html__('Show posts by category selection.', 'dexterity'),
    ),
    'show_posts' => array(
        'type' => 'slider',
        'value' => 12,
        'properties' => array(
            'min' => 0,
            'max' => 100,
            'sep' => 1,
        ),
        'label' => esc_html__('No of Posts', 'dexterity'),
    ),
    'project_view' => array(
        'type' => 'select',
        'value' => 'portfolio-view',
        'choices' => array(
            'tg-portfolio' => esc_html__('Four Column', 'dexterity'),
            'tg-portfolio-one' => esc_html__('Three Column', 'dexterity'),
            'tg-portfolio-two' => esc_html__('Two Column', 'dexterity'),
        ),
        'label' => esc_html__('Filterable', 'dexterity'),
    ),
    'show_filterable' => array(
        'type' => 'select',
        'value' => 'yes',
        'choices' => array(
            'yes' => esc_html__('YES', 'dexterity'),
            'no' => esc_html__('NO', 'dexterity'),
        ),
        'label' => esc_html__('Filterable', 'dexterity'),
    ),
);
