<?php
if (!defined('FW')) {
    die('Forbidden');
}
/**
 * @var $atts
 */
?>
<?php
/**
 * Get All Shortcode Attributes
 */
$uniq_flag = fw_unique_increment();
dexterity_init_owl_script();
?>
<div class="sc-testimonials">
    <div class="tg-testimonials">
        <?php if (isset($atts['heading']) && !empty($atts['heading'])) { ?>
            <div class="tg-heading-border">
                <h2><?php echo esc_attr($atts['heading']); ?></h2>
            </div>
        <?php } ?>
        <?php if (isset($atts['testimonials_add']) && !empty($atts['testimonials_add'])) { ?>
            <div class="tg-testimonials-slider tg-haslayout">
                <div id="tg-message-slider-<?php echo esc_attr($uniq_flag); ?>" class="tg-message-slider tg-haslayout">
                    <?php
                    $counter = 0;
                    foreach ($atts['testimonials_add'] as $testimonial) {
                        $counter++;
                        $active = $counter == 1 ? 'active' : '';
                        if (!empty($testimonial['description'])) {
                            ?>
                            <div class="item">
                                <blockquote>
                                    <q><?php echo esc_attr($testimonial['description']); ?></q>
                                </blockquote>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div id="tg-author-slider-<?php echo esc_attr($uniq_flag); ?>" class="tg-author-slider tg-haslayout">
                    <?php
                    $counter = 0;
                    foreach ($atts['testimonials_add'] as $testimonial) {
                        $counter++;
                        $active = $counter == 1 ? 'active' : '';
                        if (!empty($testimonial['description'])) {
                            ?>
                            <div class="item">
                                <?php if (!empty($testimonial['avatar']['url'])) { ?>
                                    <figure class="tg-author-img">
                                        <img src="<?php echo esc_url($testimonial['avatar']['url']); ?>" alt="<?php echo esc_attr($testimonial['title']); ?>">
                                    </figure>
                                <?php } ?>
                                <?php if (!empty($testimonial['title'])) { ?>
                                    <div class="tg-author-detail">
                                        <div class="tg-heading-border">
                                            <h3><?php echo esc_attr($testimonial['title']); ?></h3>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div> 
                        <?php } ?>
                    <?php } ?>
                </div>
            </div>
            <script>
                jQuery(document).ready(function ($) {
                    /* -------------------------------------
                     TESTIMONIALS SLIDER
                     -------------------------------------- */
                    (function () {
                        var sync1 = jQuery("#tg-message-slider-<?php echo esc_js($uniq_flag); ?>");
                        var sync2 = jQuery("#tg-author-slider-<?php echo esc_js($uniq_flag); ?>");
                        sync1.owlCarousel({
                            autoPlay: true,
                            singleItem: true,
                            slideSpeed: 1000,
                            navigation: false,
                            pagination: false,
                            afterAction: syncPosition,
                            responsiveRefreshRate: 200,
                        });
                        sync2.owlCarousel({
                            items: 3,
                            itemsDesktop: [1199, 3],
                            itemsDesktopSmall: [991, 2],
                            itemsTablet: [767, 3],
                            itemsMobile: [479, 2],
                            itemsMobile				: [360, 1],
                                    pagination: false,
                            responsiveRefreshRate: 100,
                            afterInit: function (el) {
                                el.find(".owl-item").eq(0).addClass("synced");
                            }
                        });
                        function syncPosition(el) {
                            var current = this.currentItem;
                            jQuery("#tg-author-slider-<?php echo esc_js($uniq_flag); ?>")
                                    .find(".owl-item")
                                    .removeClass("synced")
                                    .eq(current)
                                    .addClass("synced")
                            if (jQuery("#tg-author-slider-<?php echo esc_js($uniq_flag); ?>").data("owlCarousel") !== undefined) {
                                center(current)
                            }
                        }
                        jQuery("#tg-author-slider-<?php echo esc_js($uniq_flag); ?>").on("click", ".owl-item", function (e) {
                            e.preventDefault();
                            var number = jQuery(this).data("owlItem");
                            sync1.trigger("owl.goTo", number);
                        });
                        function center(number) {
                            var sync2visible = sync2.data("owlCarousel").owl.visibleItems;
                            var num = number;
                            var found = false;
                            for (var i in sync2visible) {
                                if (num === sync2visible[i]) {
                                    var found = true;
                                }
                            }
                            if (found === false) {
                                if (num > sync2visible[sync2visible.length - 1]) {
                                    sync2.trigger("owl.goTo", num - sync2visible.length + 2)
                                } else {
                                    if (num - 1 === -1) {
                                        num = 0;
                                    }
                                    sync2.trigger("owl.goTo", num);
                                }
                            } else if (num === sync2visible[sync2visible.length - 1]) {
                                sync2.trigger("owl.goTo", sync2visible[1])
                            } else if (num === sync2visible[0]) {
                                sync2.trigger("owl.goTo", num - 1)
                            }
                        }
                    }(jQuery));
                });
            </script>
        <?php } ?>
    </div>
</div>


