<?php

if (!defined('FW')) {
    die('Forbidden');
}
$options = array(
    'commingsoon_settings' => array(
        'type' => 'tab',
        'title' => esc_html__('Coming Soon', 'dexterity'),
        'options' => array(
            'commingsoon-box' => array(
                'title' => esc_html__('Coming Soon Settings', 'dexterity'),
                'type' => 'box',
                'options' => array(
                    'maintenance' => array(
                        'type' => 'switch',
                        'value' => 'disable',
                        'label' => esc_html__('Maintenance Mode', 'dexterity'),
                        'left-choice' => array(
                            'value' => 'enable',
                            'label' => esc_html__('Enable', 'dexterity'),
                        ),
                        'right-choice' => array(
                            'value' => 'disable',
                            'label' => esc_html__('Disable', 'dexterity'),
                        ),
                    ),
                    'comming_title' => array(
                        'type' => 'text',
                        'label' => esc_html__('Title', 'dexterity'),
                        'value' => 'Stay Tunned!',
                        'desc' => esc_html__('', 'dexterity'),
                    ),
                    'comming_subtitle' => array(
                        'type' => 'text',
                        'label' => esc_html__('SubTitle', 'dexterity'),
                        'value' => 'we are coming very soon',
                        'desc' => esc_html__('', 'dexterity'),
                    ),
                    'comming_description' => array(
                        'type' => 'textarea',
                        'label' => esc_html__('Description', 'dexterity'),
                        'value' => 'Add Description',
                        'desc' => esc_html__('', 'dexterity'),
                    ),
                    'background' => array(
                        'type' => 'upload',
                        'label' => esc_html__('Background Image', 'dexterity'),
                        'desc' => esc_html__('Upload Your background image on coming soon page.', 'dexterity'),
                        'images_only' => true,
                    ),
                    'date' => array(
                        'type' => 'date-picker',
                        'label' => esc_html__('Choose Date', 'dexterity'),
                        'monday-first' => true, // The week will begin with Monday; for Sunday, set to false
                        'min-date' => date('m,d,Y'), // By default minimum date will be current day. Set a date in format d-m-Y as a start date
                        'max-date' => null, // By default there is not maximum date. Set a date in format d-m-Y as a start date
                    ),
                    'enable_newsletter' => array(
                        'type' => 'switch',
                        'value' => 'enable',
                        'label' => esc_html__('Enable Newsletter', 'dexterity'),
                        'left-choice' => array(
                            'value' => 'enable',
                            'label' => esc_html__('Enable', 'dexterity'),
                        ),
                        'right-choice' => array(
                            'value' => 'disable',
                            'label' => esc_html__('Disable', 'dexterity'),
                        ),
                    ),
                )
            ),
        )
    )
);
