<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'general' => array(
        'title' => esc_html__('General', 'dexterity'),
        'type' => 'tab',
        'options' => array(
            'general-box' => array(
                'title' => esc_html__('General Settings', 'dexterity'),
                'type' => 'box',
                'options' => array(
                    'preloader' => array(
                        'type' => 'switch',
                        'value' => 'disable',
                        'label' => esc_html__('Enable Preloader', 'dexterity'),
                        'left-choice' => array(
                            'value' => 'enable',
                            'label' => esc_html__('Enable', 'dexterity'),
                        ),
                        'right-choice' => array(
                            'value' => 'disable',
                            'label' => esc_html__('Disable', 'dexterity'),
                        ),
                    ),
                   
                    'favicon' => array(
                        'label' => esc_html__('Favicon', 'dexterity'),
                        'desc' => esc_html__('Upload a favicon image', 'dexterity'),
                        'type' => 'upload'
                    ),
                    '404_title' => array(
                        'type' => 'text',
                        'value' => 'oops page not found!',
                        'label' => esc_html__('404 Title', 'dexterity'),
                    ),
                     '404_sub_title' => array(
                        'type' => 'text',
                        'value' => 'something went wrong',
                        'label' => esc_html__('404 Sub Title', 'dexterity'),
                    ),
                    '404_message' => array(
                        'type' => 'textarea',
                        'value' => 'We are really sorry but the page you requested is missing.',
                        'label' => esc_html__('404 Error Message', 'dexterity'),
                    ),
                    'search_text' => array(
                        'type' => 'textarea',
                        'value' => 'Perhaps searching can help.',
                        'label' => esc_html__('Search Message', 'dexterity'),
                    ),
                    'custom_css' => array(
                        'type' => 'textarea',
                        'label' => esc_html__('Custom CSS', 'dexterity'),
                        'desc' => esc_html__('Add your custom css code here if you want to target specifically on different elements.', 'dexterity'),
                    ),
                )
            ),
        )
    )
);
