<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'subheader' => array(
        'title' => esc_html__('Sub Header Settings', 'dexterity'),
        'type' => 'box',
        'options' => array(
            'enable_subheader' => array(
                'type' => 'switch',
                'value' => 'enable',
                'label' => esc_html__('Subheader', 'dexterity'),
                'desc' => esc_html__('Enable or Disable Subheader', 'dexterity'),
                'left-choice' => array(
                    'value' => 'enable',
                    'label' => esc_html__('Enable', 'dexterity'),
                ),
                'right-choice' => array(
                    'value' => 'disable',
                    'label' => esc_html__('Disable', 'dexterity'),
                ),
            ),
            'subheader_type' => array(
                'type' => 'multi-picker',
                'label' => false,
                'desc' => false,
                'picker' => array(
                    'gadget' => array(
                        'label' => esc_html__('Subheader Type', 'dexterity'),
                        'desc' => esc_html__('Select Subheader Type', 'dexterity'),
                        'type' => 'select',
                        'choices' => array(
                            'default' => esc_html__('Default Sub Headers', 'dexterity'),
                            'custom' => esc_html__('Custom Sub Headers', 'dexterity'),
                            'tg_slider' => esc_html__('TG Slider', 'dexterity'),
                            'rev_slider' => esc_html__('Revolution Slider', 'dexterity'),
                            'custom_shortcode' => esc_html__('Custom Shortcode', 'dexterity'),
                        )
                    )
                ),
                'choices' => array(
                    'default' => array(
                        'blog_post_image' => array(
                            'type' => 'html',
                            'html' => 'Default Subheaders',
                            'label' => esc_html__('', 'dexterity'),
                            'desc' => esc_html__('Please set default settings from theme options.', 'dexterity'),
                            'help' => esc_html__('Please Go To Appearance >> Theme Settings >> Subheaders', 'dexterity'),
                            'images_only' => true,
                        ),
                    ),
                    'custom' => array(
                        'enable_breadcrumbs' => array(
                            'type' => 'switch',
                            'value' => 'enable',
                            'label' => esc_html__('Breadcrumbs', 'dexterity'),
                            'desc' => esc_html__('Enable or Disable Breadcrumbs.', 'dexterity'),
                            'left-choice' => array(
                                'value' => 'enable',
                                'label' => esc_html__('Enable', 'dexterity'),
                            ),
                            'right-choice' => array(
                                'value' => 'disable',
                                'label' => esc_html__('Disable', 'dexterity'),
                            ),
                        ),
                        'subheader_bg_image' => array(
                            'type' => 'upload',
                            'label' => esc_html__('Upload background image', 'dexterity'),
                            'desc' => esc_html__('It will override background color', 'dexterity'),
                            'images_only' => true,
                        ),
                        'sub_header_bg' => array(
                            'type' => 'rgba-color-picker',
                            'value' => 'rgba(255,255,255,0)',
                            'label' => esc_html__('Sub Header bg color', 'dexterity'),
                            'desc' => esc_html__('Please Note that this color will override background image. If you want to set color over the image then please set as RGBA, for example: rgba(255,255,255,0)', 'dexterity'),
                        ),
                        'sub_heading_text' => array(
                            'type' => 'color-picker',
                            'value' => '#FFF',
                            'label' => esc_html__('Sub Heading Text color', 'dexterity'),
                            'desc' => esc_html__('', 'dexterity'),
                        ),
                    ),
                    'tg_slider' => array(
                        'sub_shortcode' => array(
                            'type' => 'select',
                            'value' => '',
                            'label' => esc_html__('TG Slider', 'dexterity'),
                            'desc' => esc_html__('Select Themographic Slider.', 'dexterity'),
                            'choices' => dexterity_prepare_sliders(),
                        ),
                    ),
                    'rev_slider' => array(
                        'rev_slider' => array(
                            'type' => 'select',
                            'value' => '',
                            'label' => esc_html__('Revolution Slider', 'dexterity'),
                            'desc' => esc_html__('Please Select Revolution slider.', 'dexterity'),
                            'help' => esc_html__('Please install revolution slider first.', 'dexterity'),
                            'choices' => dexterity_prepare_rev_slider(),
                        ),
                    ),
                    'custom_shortcode' => array(
                        'custom_shortcode' => array(
                            'type' => 'textarea',
                            'value' => '',
                            'desc' => esc_html__('', 'dexterity'),
                            'label' => esc_html__('Custom Slider', 'dexterity'),
                        ),
                    ),
                )
            ),
        )
    ),
    'project' => array(
        'title' => esc_html__('Project Settings', 'dexterity'),
        'type' => 'box',
        'options' => array(
            'gallery' => array(
                'type' => 'multi-upload',
                'desc' => esc_html__('Add Client', 'dexterity'),
                'label' => esc_html__('Client', 'dexterity'),
            ),
            'extras' => array(
                'type'  => 'addable-box',
                'value' => array(
                    array(
                        'label' => 'CLIENT',
                        'value' => 'ABC Contruction',
                    ),
                    array(
                        'label' => 'Category',
                        'value' => 'digging',
                    ),
                    array(
                        'label' => 'YEAR STARTED:',
                        'value' => 'June 26, 2016',
                    ),
                     array(
                        'label' => 'AREA:',
                        'value' => '580,000 m2',
                    ),
                     array(
                        'label' => 'ARCHITECTS:',
                        'value' => 'Jhon & Doe',
                    ),
                     array(
                        'label' => 'LOCATION::',
                        'value' => 'St. Petersburg, 9 Pushkin, Uk',
                    ),
                     array(
                        'label' => 'MATERIAL:',
                        'value' => 'Full Wooden',
                    ),
                ),
                'attr'  => array(),
                'label' => esc_html__('Project Info', 'dexterity'),
                'desc'  => esc_html__('', 'dexterity'),
                'help'  => esc_html__('', 'dexterity'),
                'box-options' => array(
                    'label' => array( 'type' => 'text' ),
                    'value' => array( 'type' => 'text' ),
                ),
                'template' => '{{- label }}', // box title
                'box-controls' => array( // buttons next to (x) remove box button
                    'control-id' => '<small class="dashicons dashicons-smiley"></small>',
                ),
                'limit' => 0, // limit the number of boxes that can be added
                'add-button-text' => esc_html__('Add', 'dexterity'),
                'sortable' => true,
            ),
            'social_icons' => array(
                'label' => esc_html__('Social Icons', 'dexterity'),
                'type' => 'addable-popup',
                'value' => array(),
                'desc' => esc_html__('Add Social Icons as much as you want. Choose the icon, url and the title', 'dexterity'),
                'popup-options' => array(
                    'social_name' => array(
                        'label' => esc_html__('Title', 'dexterity'),
                        'type' => 'text',
                        'value' => 'Name',
                        'desc' => esc_html__('The Title of the Link', 'dexterity')
                    ),
                    'social_icons_list' => array(
                        'type' => 'new-icon',
                        'value' => 'fa-smile-o',
                        'attr' => array(),
                        'label' => esc_html__('Choos Icon', 'dexterity'),
                        'desc' => esc_html__('', 'dexterity'),
                        'help' => esc_html__('', 'dexterity'),
                    ),
                    'social_url' => array(
                        'label' => esc_html__('Url', 'dexterity'),
                        'type' => 'text',
                        'value' => '#',
                        'desc' => esc_html__('The link to the social profile.', 'dexterity')
                    ),
                ),
                'template' => '{{- social_name }}',
            ),
           
        )
    ),
);
