<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'subheaders' => array(
        'title' => esc_html__('Sub Headers', 'dexterity'),
        'type' => 'tab',
        'options' => array(
            'general-box' => array(
                'title' => esc_html__('Sub Header Settings', 'dexterity'),
                'type' => 'box',
                'options' => array(
                    '404_heading' => array(
                        'type' => 'text',
                        'value' => '404 ERROR',
                        'label' => esc_html__('404 Page Title', 'dexterity'),
                        'desc' => esc_html__('', 'dexterity'),
                    ),
                    'archives_heading' => array(
                        'type' => 'text',
                        'value' => 'Archives',
                        'label' => esc_html__('Archives Sub Heading', 'dexterity'),
                        'desc' => esc_html__('', 'dexterity'),
                    ),
                    'search_heading' => array(
                        'type' => 'text',
                        'value' => 'Search',
                        'label' => esc_html__('Search Sub Heading', 'dexterity'),
                        'desc' => esc_html__('', 'dexterity'),
                    ),
                    'enable_breadcrumbs' => array(
                        'type' => 'switch',
                        'value' => 'enable',
                        'label' => esc_html__('Breadcrumbs', 'dexterity'),
                        'desc' => esc_html__('Enable or Disable Breadcrumbs.', 'dexterity'),
                        'left-choice' => array(
                            'value' => 'enable',
                            'label' => esc_html__('Enable', 'dexterity'),
                        ),
                        'right-choice' => array(
                            'value' => 'disable',
                            'label' => esc_html__('Disable', 'dexterity'),
                        ),
                    ),
                    'subheader_bg_image' => array(
                        'type' => 'upload',
                        'value' => '',
                        'label' => esc_html__('Upload background image', 'dexterity'),
                        'desc' => esc_html__('It will override background color', 'dexterity'),
                        'images_only' => true,
                    ),
                    'sub_header_bg' => array(
                        'type' => 'rgba-color-picker',
                        'value' => 'rgba(255,255,255,0)',
                        'label' => esc_html__('Sub Header bg color', 'dexterity'),
                        'desc' => esc_html__('Please Note that this color will override background image. If you want to set color over the image then please set as RGBA, for example: rgba(255,255,255,0)', 'dexterity'),
                    ),
                )
            ),
        )
    )
);
