<?php
/**
 * @Class footers
 *
 */
if (!class_exists('dexterity_footers')) {

    class dexterity_footers {

        function __construct() {
             add_action('dexterity_init_footers', array(&$this, 'dexterity_init_footers'));
        }

        /**
         * @Init Footers
         * @return {}
         */
        public function dexterity_init_footers() {
			$footer_copyright = '&copy; '.date('Y') . esc_html__(' | All Rights Reserved ', 'dexterity') . get_bloginfo();
			$enable_widget_area = '';
			$enable_menu = '';
			$appointment_logo = '';
			$hire = '';
			if (function_exists('fw_get_db_settings_option')) {
				$enable_widget_area = fw_get_db_settings_option('enable_widget_area', $default_value = null);
				$footer_copyright = fw_get_db_settings_option('footer_copyright', $default_value = null);
				$enable_menu = fw_get_db_settings_option('enable_menu', $default_value = null);
				$appointment_logo = fw_get_db_settings_option('appointment_logo', $default_value = null);
				$hire = fw_get_db_settings_option('hire_botton');
			}
			
			if (isset($enable_widget_area) && $enable_widget_area === 'on') {
				$widgetClass = 'widgets-enable';
			} else {
				$widgetClass = 'widgets-disbale';
			}
			
			?>
            </main>
            </div>
             <?php 
            if ( isset( $hire ) && $hire === 'enable') { 
                $flag = fw_unique_increment();
                dexterity_init_datepicker_script();
             ?>
            <div class="modal fade tg-login-lightbox" tabindex="-1" role="dialog">
                <div class="tg-lightbox">
                    <div class="tg-lightbox-content">
                        <h2><?php esc_html_e('make an appointment', 'dexterity'); ?></h2>
                        <div class="appointment_wrap">
                            <div class="message_apt"></div>
                            <form class="contact_form appointment_form">
                                <fieldset>
                                    <?php wp_nonce_field('dexterity_submit_appointment', 'security'); ?>
                                    <div class="tg-col">
                                        <input type="text" name="appointment[apt_name]" class="form-control" placeholder="<?php esc_attr_e('Name', 'dexterity'); ?>">
                                        <input type="text" name="appointment[apt_email]" class="form-control" placeholder="<?php esc_attr_e('Email', 'dexterity'); ?>">
                                        <input type="text" name="appointment[apt_phone]" class="form-control" placeholder="<?php esc_attr_e('Mobile', 'dexterity'); ?>">
                                        <input type="text" id="booking-date-<?php echo esc_attr( $flag );?>"  name="appointment[apt_date]" class="form-control" placeholder="<?php esc_attr_e('appointment date', 'dexterity'); ?>">
                                        <textarea  name="appointment[apt_message]" class="form-control" placeholder="<?php esc_attr_e('message', 'dexterity'); ?>"></textarea>
                                        <script>
                                            jQuery(document).ready(function(e) {
                                                jQuery('#booking-date-<?php echo esc_js( $flag );?>').datepicker({
                                                    autoclose: true,
                                                    format: 'dd-mm-yyyy',
                                                });
                                            });
                                        </script>
                                    </div>
                                    <div class="tg-col">
                                        <?php
                                        $query_args = array('posts_per_page' => "-1", 'post_type' => 'tg_services', 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);
                                        $query = new WP_Query($query_args);
                                        if ($query->have_posts()) :
                                            while ($query->have_posts()) : $query->the_post();
                                                global $post;
                                                $media_type = fw_get_db_post_option($post->ID, 'media_type', true);
                                                if (isset($media_type['gadget']) && $media_type['gadget'] === 'image') {
                                                    $media = '<img src="' . $media_type['image']['vehicle_image']['url'] . '" />';
                                                } elseif (isset($media_type['gadget']) && $media_type['gadget'] === 'icon') {
                                                    $media = '<i class="' . $media_type['icon']['vehicle_icon'] . '"></i>';
                                                } else {
                                                    $media = '<i class="icon-sports-car"></i>';
                                                }
                                                ?>
                                                <div class="tg-checkbox">
                                                    <input id="<?php echo sanitize_html_class(get_the_title()); ?>" name="appointment[apt_services][]" type="checkbox" value="<?php echo intval( $post->ID ); ?>">
                                                    <label for="<?php echo sanitize_html_class(get_the_title()); ?>">
                                                        <span class="tg-heading-border"><?php the_title() ?></span>
                                                        <?php echo force_balance_tags($media); ?>
                                                    </label>
                                                </div>
                                                <?php
                                            endwhile;
                                        endif;
                                        ?>
                                    </div>
                                    <?php if( isset( $appointment_logo['url'] ) && !empty( $appointment_logo['url'] ) ) {?>
                                    <figure><img src="<?php echo esc_url( $appointment_logo['url'] );?>" alt="<?php esc_html_e('Book now', 'dexterity'); ?>" /></figure>
                                    <?php }?>
                                    <div class = "formgroup">
                                        <button class = "tg-btn make-appointment" type = "submit"><?php esc_html_e('Book now', 'dexterity'); ?></button>
                                    </div>
                                </fieldset>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php }?>
            <footer id = "tg-footer" class = "tg-footer tg-haslayout">
                <div class = "container">
                    <div class = "row">
                        <?php if (isset($enable_widget_area) && $enable_widget_area === 'on') {
                            ?>
                            <div class="tg-three-columns <?php echo sanitize_html_class($widgetClass); ?>">
                                <?php if (is_active_sidebar('footer-column-1')) { ?>
                                    <div class="col-sm-4">
                                        <div class="tg-column">
                                            <?php dynamic_sidebar('footer-column-1'); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if (is_active_sidebar('footer-column-2')) { ?>
                                    <div class="col-sm-4">
                                        <div class="tg-column">
                                            <?php dynamic_sidebar('footer-column-2'); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if (is_active_sidebar('footer-column-3')) { ?>
                                    <div class="col-sm-4">
                                        <div class="tg-column">
                                            <?php dynamic_sidebar('footer-column-3'); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="tg-footerbar">
                    <div class="container">
                        <div class="row">
                            <div class="col-xs-12">
                                <?php if (isset($enable_menu) && $enable_menu === 'on') { ?>
                                    <nav class="tg-footer-nav pull-right">
                                        <?php dexterity_headers::dexterity_prepare_navigation('footer-menu', '', '', '0'); ?>
                                    </nav>
                                <?php } ?>
                                <?php if (isset($footer_copyright) && $footer_copyright != '') { ?>
                                    <p class="tg-copyright pull-left"><?php echo force_balance_tags($footer_copyright); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <?php
		}
		
    }

    new dexterity_footers();
}