<?php
/**
 * Jetpack Compatibility File
 * See: https://jetpack.me/
 *
 * @package Dexterity
 */

/**
 * Add theme support for Infinite Scroll.
 * See: https://jetpack.me/support/infinite-scroll/
 */
if (!function_exists('dexterity_jetpack_setup')) {
	function dexterity_jetpack_setup() {
		add_theme_support( 'infinite-scroll', array(
			'container' => 'main',
			'render'    => 'dexterity_infinite_scroll_render',
			'footer'    => 'page',
		) );
	} // end function dexterity_jetpack_setup
	add_action( 'after_setup_theme', 'dexterity_jetpack_setup' );
}

if (!function_exists('dexterity_infinite_scroll_render')) {
	function dexterity_infinite_scroll_render() {
		while ( have_posts() ) {
			the_post();
			get_template_part( 'template-parts/content', get_post_format() );
		}
	} // end function dexterity_infinite_scroll_render
}