<?php
/**
 * The template for displaying all single posts.
 *
 * @package Dexterity
 */
get_header();
$uni_flag = rand(1,9999);
$dexterity_sidebar = 'full';
$section_width = 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
if (function_exists('fw_ext_sidebars_get_current_position')) {
	$current_position = fw_ext_sidebars_get_current_position();
	if ($current_position != 'full' && ( $current_position == 'left' || $current_position == 'right' )) {
		$dexterity_sidebar = $current_position;
		$section_width = 'col-lg-9 col-md-8 col-sm-8 col-xs-12';
	}
}
if (isset($dexterity_sidebar) && $dexterity_sidebar == 'right') {
	$aside_class = 'pull-right';
	$content_class = 'pull-left';
} else {
	$aside_class = 'pull-left';
	$content_class = 'pull-right';
}
?>
<div class="container">
	<div class="row">
		<div id="tg-towcolumns" class="tg-haslayout">
			<div class="<?php echo esc_attr($section_width); ?> <?php echo sanitize_html_class($content_class); ?>">
				<?php
				while (have_posts()) : the_post();
					if (function_exists('dexterity_init_owl_script')) {
						dexterity_init_owl_script();
					}
					$user_ID = get_the_author_meta('ID');
					$udata = get_userdata($user_ID);
					$registered = $udata->user_registered;
					$user_avatar_display = get_the_author_meta('user_avatar_display', $user_ID);
					$height = 450;
					$width = 1170;
					$thumbnail = dexterity_prepare_thumbnail($post->ID, $width, $height);
					$image_src = dexterity_prepare_thumbnail($post->ID, 'full');
					$user_id = get_the_author_meta('ID');
					$user_url = get_author_posts_url($user_id);
					$flag = rand(99, 99999);
					if (!function_exists('fw_get_db_post_option')) {
						$blog_settings = '';
						$enable_auhtor_info = '';
					} else {
						$blog_settings = fw_get_db_post_option($post->ID, 'post_settings', true);
						$enable_auhtor_info = fw_get_db_post_option($post->ID, 'enable_auhtor_info', true);
					}
					if (isset($blog_settings) && $blog_settings == 'gallery') {
						$blogClass = 'gallery-post';
					} else if (isset($blog_settings) && $blog_settings == 'slider') {
						$blogClass = 'tg-post-slider';
					} else if (isset($blog_settings) && $blog_settings == 'video') {
						$url = parse_url($blog_post_video_custom);
						if ($url['host'] == 'soundcloud.com') {
							$blogClass = 'tg-audio-post';
						} else {
							$blogClass = 'tg-video-post';
						}
					} else {
						$blogClass = '';
					}
					$blog_post_gallery = array();
					$post_video = '';
					if (isset($blog_settings['gallery']['blog_post_gallery']) && !empty($blog_settings['gallery']['blog_post_gallery'])) {
						$blog_post_gallery = $blog_settings['gallery']['blog_post_gallery'];
					}
					if (isset($blog_settings['video']['blog_video_link']) && !empty($blog_settings['video']['blog_video_link'])) {
						$post_video = $blog_settings['video']['blog_video_link'];
					}
					?>
					<div id="tg-content" class="tg-content tg-blogdetail tg-haslayout">
						<article class="tg-singlepost tg-haslayout">
							<?php if (isset($blog_settings['gadget']) && $blog_settings['gadget'] === 'image' && !empty($thumbnail)) { ?>
								<figure class="tg-post-img tg-haslayout">
									<img src="<?php echo esc_url($thumbnail); ?>" alt="<?php the_title(); ?>">
								</figure>	
								<?php
							} elseif (isset($blog_settings['gadget']) && $blog_settings['gadget'] === 'gallery' && !empty($blog_post_gallery) && $blog_post_gallery != '') {
								$uniq_flag = rand(99, 99999);
								?>
								<div class="row">
									<div class="col-sm-10 tg-verticalbottom">
										<a class="tg-btn"><?php esc_html_e('by: ', 'dexterity'); ?> <?php echo ucfirst(get_the_author_meta('nickname')); ?></a>
										<div id="tg-blogdetail-slider" class="tg-blogdetail-slider tg-haslayout">
											<div class="swiper-container gallery-top">
												<div class="swiper-wrapper">
													<?php
													foreach ($blog_post_gallery as $blog_gallery) {
														$attachment_id = $blog_gallery['attachment_id'];
														$image_data = wp_get_attachment_image_src($attachment_id, 'dexterity_blog_listing');
														if (isset($image_data) && !empty($image_data) && $image_data[0] != '') {
															?>
															<div class="swiper-slide">
																<img src="<?php echo esc_url($image_data[0]); ?>" alt="<?php echo get_bloginfo('name'); ?>">
															</div>
															<?php
														}
													}
													?>
												</div>
											</div>
											<div class="swiper-button-next swiper-button-white"></div>
											<div class="swiper-button-prev swiper-button-white"></div>
										</div>
									</div>
									<div class="col-sm-2 tg-verticalbottom">
										<div id="tg-blogdetail-thumb-slider" class="tg-blogdetail-thumb-slider">
											<div class="swiper-container gallery-thumbs">
												<div class="swiper-wrapper">
													<?php
													foreach ($blog_post_gallery as $blog_gallery) {
														$attachment_id = $blog_gallery['attachment_id'];
														$image_data = wp_get_attachment_image_src($attachment_id, array(300, 300));
														if (isset($image_data) && !empty($image_data) && $image_data[0] != '') {
															?>
															<div class="swiper-slide">
																<figure>
																	<img src="<?php echo esc_url($image_data[0]); ?>" alt="<?php echo get_bloginfo('name'); ?>">
																	<div class="tg-img-hover">
																		<a><i class="fa fa-plus"></i></a>
																	</div>
																</figure>
															</div>
															<?php
														}
													}
													?>
												</div>
											</div>
										</div>
									</div>
								</div>
								<?php
							} elseif (isset($blog_settings['gadget']) && $blog_settings['gadget'] === 'video') {
								$url = parse_url($post_video);
								if (isset($url['host']) && $url['host'] == $_SERVER["SERVER_NAME"]) {
									echo '<figure class="tg-post-img tg-haslayout"><div class="video">';
									echo do_shortcode('[video width="' . $width . '" height="' . $height . '" src="' . $post_video . '"][/video]');
									echo '</div></figure>';
								} else {
									if (isset($url['host']) && ( $url['host'] == 'vimeo.com' || $url['host'] == 'player.vimeo.com')) {
										echo '<figure class="tg-post-img tg-haslayout"><div class="video">';
										$content_exp = explode("/", $post_video);
										$content_vimo = array_pop($content_exp);
										echo '<iframe width="' . $width . '" height="' . $height . '" src="https://player.vimeo.com/video/' . $content_vimo . '" 
							></iframe>';
										echo '</div></figure>';
									} elseif (isset($url['host']) && $url['host'] == 'soundcloud.com') {
										$height = 205;
										$width = 1140;
										$video = wp_oembed_get($post_video, array('height' => $height));
										$search = array('webkitallowfullscreen', 'mozallowfullscreen', 'frameborder="no"', 'scrolling="no"');
										echo '<figure class="tg-post-img tg-haslayout"><div class="audio">';
										$video = str_replace($search, '', $video);
										echo str_replace('&', '&amp;', $video);
										echo '</div></figure>';
									} else {
										echo '<figure class="tg-post-img tg-haslayout"><div class="video">';
										$content = str_replace(array('watch?v=', 'http://www.dailymotion.com/'), array('embed/', '//www.dailymotion.com/embed/'), $post_video);
										echo '<iframe width="' . $width . '" height="' . $height . '" src="' . $content . '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
										echo '</div></figure>';
									}
								}
							}
							?>
							
								<div class="tg-heading-border">
									<h3><?php the_title(); ?></h3>
								</div>
								<div class="tg-description">
									<?php the_content(); ?>
								</div>
								<div class="tg-tags-shareicons tg-haslayout">
									<?php the_tags('<div class="tg-tagsbox pull-left"><strong>' . esc_html__('TAGS:', 'dexterity') . '</strong><ul class="tg-tags"><li>', '</li><li>', '</li></ul></div>'); ?>
									<div class="tg-post-shareicons pull-right">
										<strong><?php esc_html_e('SHARE:', 'dexterity') ?></strong>
										<?php
											if (function_exists('dexterity_prepare_social_sharing')) {
												dexterity_prepare_social_sharing();
											}
										?>
									</div>
								</div>
								<?php if (isset($enable_auhtor_info) && $enable_auhtor_info === 'enable') { ?>
									<div class="tg-about-author tg-haslayout">
										<figure class="tg-author-img">
											<?php
											if (isset($user_avatar_display) && !empty($user_avatar_display) && $user_avatar_display != '') {
												echo '<img src="' . esc_url($user_avatar_display) . '" alt="' . esc_attr__('Author Avatar', 'dexterity') . '">';
											} else {
												echo get_avatar($user_ID, '', '', '', array('width' => 140, 'height' => 102));
											}
											?>
										</figure>
										<div class="tg-author-info">
											<div class="tg-heading-border">
												<h3><?php esc_html_e('About Author', 'dexterity'); ?></h3>
											</div>
											<div class="tg-description">
												<p><?php echo get_the_author_meta('description'); ?></p>
											</div>
										</div>
									</div>
								<?php } ?>
								<?php
								if (comments_open() || get_comments_number()) :
									comments_template();
								endif;
								?>
							
						</article>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
			<?php if (function_exists('fw_ext_sidebars_get_current_position')) { ?>
				<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
					<aside id="tg-sidebar" class="tg-sidebar tg-haslayout sidebar-section <?php echo sanitize_html_class($aside_class); ?>"> <?php echo fw_ext_sidebars_show('blue'); ?>
					</aside>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>