<?php
/**
 * File Type: Appointments
 */
if( ! class_exists('TG_Appointments') ) {
	
	class TG_Appointments {
	
		public function __construct() {
			global $pagenow;
			add_action('init', array(&$this, 'init_appointments'));
			add_filter('manage_tg_appointments_posts_columns', array(&$this, 'tg_appointment_columns_add'));
			add_action('manage_tg_appointments_posts_custom_column', array(&$this, 'tg_appointment_columns'),10, 2);								
		}
		
		/**
		 * @Init Post Type
		 * @return {post}
		 */
		public function init_appointments(){
			$this->prepare_post_type();
		}
		
		/**
		 * @Prepare Post Type
		 * @return {}
		 */
		public function prepare_post_type(){
			$labels = array(
				'name' 				 => __( 'Appointments', 'themographics_core' ),
				'all_items'			 => __( 'Appointments', 'themographics_core' ),
				'singular_name'      => __( 'Appointments', 'themographics_core' ),
				'add_new'            => __( 'Add Appointments', 'themographics_core' ),
				'add_new_item'       => __( 'Add New Appointments', 'themographics_core' ),
				'edit'               => __( 'Edit', 'themographics_core' ),
				'edit_item'          => __( 'Edit Appointment', 'themographics_core' ),
				'new_item'           => __( 'New Appointment', 'themographics_core' ),
				'view'               => __( 'View Appointment', 'themographics_core' ),
				'view_item'          => __( 'View Appointment', 'themographics_core' ),
				'search_items'       => __( 'Search Appointment', 'themographics_core' ),
				'not_found'          => __( 'No Appointments found', 'themographics_core' ),
				'not_found_in_trash' => __( 'No Appointments found in trash', 'themographics_core' ),
				'parent'             => __( 'Parent Appointments', 'themographics_core' ),
			);
			$args = array(
				'labels'			  => $labels,
				'description'         => __( 'This is where you can add new Appointments', 'themographics_core' ),
				'public'              => true,
				'supports'            => array( 'title','editor' ),
				'show_ui'             => true,
				'capability_type'     => 'post',
				'map_meta_cap'        => true,
				'publicly_queryable'  => true,
				'exclude_from_search' => false,
				'hierarchical'        => false,
				'menu_position' 	  => 10,
				'rewrite'			  => array('slug' => 'tg_appointments', 'with_front' => true),
				'query_var'           => false,
				'has_archive'         => 'false',
			); 
			register_post_type( 'tg_appointments' , $args );
			
		}
		
		/**
		 * @Prepare Columns
		 * @return {post}
		 */
		public function tg_appointment_columns_add($columns) {
			unset($columns['date']);
			$columns['apt_date'] = esc_html__('Appointment Date','dossier');
			$columns['apt_email'] = esc_html__('Email','dossier');
			$columns['apt_phone'] = esc_html__('Phone','dossier');
		 
  			return $columns;
		}
		
		/**
		 * @Get Columns
		 * @return {}
		 */
		public function tg_appointment_columns($name) {
			global $post;
			
			if (!function_exists('fw_get_db_post_option')) {		
				$apt_email = '';
				$apt_date = '';
				$apt_phone = '';
			} else {
				$apt_email = fw_get_db_post_option($post->ID, 'apt_email', true);
				$apt_date = fw_get_db_post_option($post->ID, 'apt_date', true);
				$apt_phone = fw_get_db_post_option($post->ID, 'apt_phone', true);
			}
						
			switch ($name) {	
				case 'apt_date':
					echo esc_attr( $apt_date );
				break;	
				case 'apt_email':
					echo esc_attr( $apt_email );
				break;	
				case 'apt_phone':
					echo esc_attr( $apt_phone );
				break;		
			}
		}

	}
	
  	new TG_Appointments();	
}