<?php
/**
 * File Type: Project
 */
if( ! class_exists('TG_Project') ) {
	
	class TG_Project {
	
		public function __construct() {
			global $pagenow;
			add_action('init', array(&$this, 'init_projects'));			
			add_action( 'init', array(&$this,'init_project_taxonomies') );	
			//add_filter('manage_tg_projects_posts_columns', array(&$this, 'projects_columns_add'));
			//add_action('manage_tg_projects_posts_custom_column', array(&$this, 'projects_columns'),10, 2);												
		}
		
		/**
		 * @Init Post Type
		 * @return {post}
		 */
		public function init_projects(){
			$this->prepare_post_type();
		}
		
		/**
		 * @Prepare Post Type
		 * @return {}
		 */
		public function prepare_post_type(){
			$labels = array(
				'name' 				 => esc_html__( 'Projects', 'themographics_core' ),
				'all_items'			 => esc_html__( 'Projects', 'themographics_core' ),
				'singular_name'      => esc_html__( 'Project', 'themographics_core' ),
				'add_new'            => esc_html__( 'Add Project', 'themographics_core' ),
				'add_new_item'       => esc_html__( 'Add New Project', 'themographics_core' ),
				'edit'               => esc_html__( 'Edit', 'themographics_core' ),
				'edit_item'          => esc_html__( 'Edit Project', 'themographics_core' ),
				'new_item'           => esc_html__( 'New Project', 'themographics_core' ),
				'view'               => esc_html__( 'View Project', 'themographics_core' ),
				'view_item'          => esc_html__( 'View Project', 'themographics_core' ),
				'search_items'       => esc_html__( 'Search Project', 'themographics_core' ),
				'not_found'          => esc_html__( 'No Project found', 'themographics_core' ),
				'not_found_in_trash' => esc_html__( 'No Project found in trash', 'themographics_core' ),
				'parent'             => esc_html__( 'Parent Project', 'themographics_core' ),
			);
			$args = array(
				'labels'			  => $labels,
				'description'         => esc_html__( 'This is where you can add new Project', 'themographics_core' ),
				'public'              => true,
				'supports'            => array( 'title','editor','thumbnail' ),
				'show_ui'             => true,
				'capability_type'     => 'post',
				'map_meta_cap'        => true,
				'publicly_queryable'  => true,
				'exclude_from_search' => false,
				'hierarchical'        => false,
				'menu_position' 	  => 10,
				'rewrite'			  => array('slug' => 'projects', 'with_front' => true),
				'query_var'           => false,
				'has_archive'         => 'false',
			); 
			register_post_type( 'tg_projects' , $args );
			
		}
		
		/**
		 * @Prepare Project Project
		 * @return {}
		 */
		public function init_project_taxonomies() {
			$labels = array(
				'name'              => esc_html__( 'Categories', 'taxonomy general name', 'themographics_core' ),
				'singular_name'     => esc_html__( 'Categories', 'taxonomy singular name' , 'themographics_core'),
				'search_items'      => esc_html__( 'Search Category' , 'themographics_core'),
				'all_items'         => esc_html__( 'All Category' , 'themographics_core'),
				'parent_item'       => esc_html__( 'Parent Category' , 'themographics_core'),
				'parent_item_colon' => esc_html__( 'Parent Category:' , 'themographics_core'),
				'edit_item'         => esc_html__( 'Edit Category' , 'themographics_core'),
				'update_item'       => esc_html__( 'Update Category' , 'themographics_core'),
				'add_new_item'      => esc_html__( 'Add New Category' , 'themographics_core'),
				'new_item_name'     => esc_html__( 'New Category Name', 'themographics_core' ),
				'menu_name'         => esc_html__( 'Categories', 'themographics_core' ),
			);
		
			$args = array(
				'hierarchical'      => true, // Set this to 'false' for non-hierarchical taxonomy (like tags)
				'labels'            => $labels,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
				'rewrite'           => array( 'slug' => 'projects' ),
			);
		
			register_taxonomy( 'project-category', array( 'tg_projects' ), $args );
		}
		
		/**
		 * @Prepare Columns
		 * @return {post}
		 */
		public function projects_columns_add($columns) {
			//$columns['thumbnail'] 		= esc_html__('Thumbnail','themographics_core');
		 
  			return $columns;
		}
		
		/**
		 * @Get Columns
		 * @return {}
		 */
		public function projects_columns($name) {
			global $post;
			switch ($name) {
				case 'thumbnail':
					//echo '<img class="project-thumnail-image" src="'.$thumbnail.'">';
				break;		
				
			}
		}
			
	}
	
  	new TG_Project();	
}