<?php
/**
 * File Type: Slider
 */
if (!class_exists('SC_Slider')) {

    class SC_Slider {

        public function __construct() {
            add_shortcode('themographics_slider', array(&$this, 'shortCodeCallBack'));
        }

        /**
         * return Slider Data
         *
         */
        public function shortCodeCallBack($args, $content = '') {
            if (isset($args['id']) && !empty($args['id'])) {
                if (function_exists('fw_get_db_settings_option')) {
                    $slider_type = fw_get_db_post_option($args['id'], 'slider_type', true);

                    if (isset($slider_type['gadget']) && $slider_type['gadget'] === 'slider_v2') {
                        $this->tg_prepare_dexterity_v2($args['id']);
                    } elseif (isset($slider_type['gadget']) && $slider_type['gadget'] === 'slider_v3') {
                        $this->tg_prepare_dexterity_v3($args['id']);
                    } else {
                        $this->tg_prepare_dexterity_v1($args['id']);
                    }
                } else {
                    esc_html_e('Oops! No data Found', 'themographics_core');
                }
            }
        }

        /**
         * @Carousel Slider
         * @return {HTML}
         * */
        public function tg_prepare_dexterity_v1($id = '') {

            $custom_classes = fw_get_db_post_option($id, 'custom_classes', true);
            $margin_top = fw_get_db_post_option($id, 'margin_top', true);
            $margin_bottom = fw_get_db_post_option($id, 'margin_bottom', true);
            $auto = fw_get_db_post_option($id, 'auto', true);
            $pagination = fw_get_db_post_option($id, 'pagination', true);

            $slider_type = fw_get_db_post_option($id, 'slider_type', true);
            $v1_slides = $slider_type['slider_v1']['carousel_slides'];

            $autoPlay = 'true';
            if (isset($auto) && $auto == 'disable') {
                $autoPlay = 'false';
            }

            $navigation = 'true';
            if (isset($pagination) && $pagination == 'disable') {
                $navigation = 'false';
            }

            $flag = fw_unique_increment();

            $css = array();
            if (isset($margin_top) && !empty($margin_top)) {
                $css[] = 'margin-top:' . $margin_top . 'px;';
            }

            if (isset($margin_bottom) && !empty($margin_bottom)) {
                $css[] = 'margin-bottom:' . $margin_bottom . 'px;';
            }

            $image_src = '';

            if (isset($slide['url']) && !empty($slide['url'])) {
                $image_src = $slide['url'];
            }

            if (isset($v1_slides) && is_array($v1_slides) && !empty($v1_slides)) {
                dexterity_init_owl_script(); //OWL Carousel Init
                ?>
                <div class="tg-custom-slider" style="<?php echo implode(' ', $css); ?>">
                    <div id="home-slider-<?php echo esc_attr($flag); ?>" class="home-slider tg-haslayout">
                        <?php
                        $counter = 0;
                        foreach ($v1_slides as $key => $value) {
                            $counter++;
                            $slide_banner = $value['slide_banner'];
                            $slide_title = $value['slide_title'];
                            $button_title = $value['button_title'];
                            $button_link = $value['button_link'];
                            ?>
                            <div class="item">
                                <figure>
                                    <?php if (isset($value['slide_banner']['url']) && !empty($value['slide_banner']['url'])) { ?>
                                        <img src="<?php echo esc_url($value['slide_banner']['url']); ?>" alt="<?php echo esc_attr($slide_title); ?>">
                                    <?php } ?>
                                    <figcaption>
                                        <?php if (isset($slide_title) && !empty($slide_title)) { ?>
                                            <div class="tg-theme-heading">
                                                <h1><?php echo force_balance_tags($slide_title); ?></h1>
                                            </div>
                                        <?php } ?>
                                        <?php if (isset($button_title) && !empty($button_title)) { ?>
                                            <a class="tg-btn" href="<?php echo esc_url($value['button_link']); ?>"><?php echo esc_attr($button_title); ?></a>
                                        <?php } ?>
                                    </figcaption>
                                </figure>
                            </div>
                        <?php } ?>

                    </div>
                    <script>
                        jQuery(document).ready(function () {
                            jQuery("#home-slider-<?php echo esc_js($flag); ?>").owlCarousel({
                                autoPlay: <?php echo esc_js($autoPlay); ?>,
                                slideSpeed: 300,
                                paginationSpeed: 400,
                                singleItem: true,
                                navigation: false,
                                pagination: <?php echo esc_js($navigation); ?>,
                                navigationText: [
                                    "<i class='fa fa-angle-left'></i>",
                                    "<i class='fa fa-angle-right'></i>"
                                ]
                            });
                        });


                    </script>
                </div>

                <?php
            }
        }

        /**
         * @Slider V2
         * @return {HTML}
         * */
        public function tg_prepare_dexterity_v2($id = '') {

            $custom_classes = fw_get_db_post_option($id, 'custom_classes', true);
            $margin_top = fw_get_db_post_option($id, 'margin_top', true);
            $margin_bottom = fw_get_db_post_option($id, 'margin_bottom', true);
            $auto = fw_get_db_post_option($id, 'auto', true);
            $pagination = fw_get_db_post_option($id, 'pagination', true);

            $slider_type = fw_get_db_post_option($id, 'slider_type', true);
            $v2_slides = $slider_type['slider_v2']['carousel_slides'];

            $autoPlay = 'true';
            if (isset($auto) && $auto == 'disable') {
                $autoPlay = 'false';
            }

            $navigation = 'true';
            if (isset($pagination) && $pagination == 'disable') {
                $navigation = 'false';
            }

            $flag = fw_unique_increment();

            $css = array();
            if (isset($margin_top) && !empty($margin_top)) {
                $css[] = 'margin-top:' . $margin_top . 'px;';
            }

            if (isset($margin_bottom) && !empty($margin_bottom)) {
                $css[] = 'margin-bottom:' . $margin_bottom . 'px;';
            }

            $image_src = '';

            if (isset($slide['url']) && !empty($slide['url'])) {
                $image_src = $slide['url'];
            }

            if (isset($v2_slides) && is_array($v2_slides) && !empty($v2_slides)) {
                dexterity_init_owl_script(); //OWL Carousel Init
                ?>
                <div class="tg-custom-slider" style="<?php echo implode(' ', $css); ?>">
                    <div id="home-slider-<?php echo esc_attr($flag); ?>" class="home-slider home-slider2 tg-haslayout">
                        <?php
                        $counter = 0;
                        foreach ($v2_slides as $key => $value) {
                            $counter++;
                            $slide_banner = $value['slide_banner'];
                            $slide_title = $value['slide_title'];
                            $button_title = $value['button_title'];
                            $button_link = $value['button_link'];
                            ?>
                            <div class="item">
                                <figure>
                                    <?php if (isset($value['slide_banner']['url']) && !empty($value['slide_banner']['url'])) { ?>
                                        <img src="<?php echo esc_url($value['slide_banner']['url']); ?>" alt="<?php echo esc_attr($slide_title); ?>">
                                    <?php } ?>
                                    <figcaption>
                                        <?php if (isset($slide_title) && !empty($slide_title)) { ?>
                                            <div class="tg-theme-heading">
                                                <h1><?php echo force_balance_tags($slide_title); ?></h1>
                                            </div>
                                        <?php } ?>
                                        <?php if (isset($button_title) && !empty($button_title)) { ?>
                                            <a class="tg-btn" href="<?php echo esc_url($value['button_link']); ?>"><?php echo esc_attr($button_title); ?></a>
                                        <?php } ?>
                                    </figcaption>
                                </figure>
                            </div>
                        <?php } ?>

                    </div>
                    <script>
                        jQuery(document).ready(function () {
                            jQuery("#home-slider-<?php echo esc_js($flag); ?>").owlCarousel({
                                autoPlay: <?php echo esc_js($autoPlay); ?>,
                                slideSpeed: 300,
                                paginationSpeed: 400,
                                singleItem: true,
                                navigation: false,
                                pagination: <?php echo esc_js($navigation); ?>,
                                navigationText: [
                                    "<i class='fa fa-angle-left'></i>",
                                    "<i class='fa fa-angle-right'></i>"
                                ]
                            });
                        });


                    </script>
                </div>

                <?php
            }
        }

        /**
         * @Slider V3
         * @return {HTML}
         * */
        public function tg_prepare_dexterity_v3($id = '') {
            $flag = fw_unique_increment();
            $custom_classes = fw_get_db_post_option($id, 'custom_classes', true);
            $margin_top = fw_get_db_post_option($id, 'margin_top', true);
            $margin_bottom = fw_get_db_post_option($id, 'margin_bottom', true);
            $auto = fw_get_db_post_option($id, 'auto', true);
            $pagination = fw_get_db_post_option($id, 'pagination', true);

            $slider_type = fw_get_db_post_option($id, 'slider_type', true);
            $v3_slides = $slider_type['slider_v3']['carousel_slides'];

            $autoPlay = 'true';
            if (isset($auto) && $auto == 'disable') {
                $autoPlay = 'false';
            }

            $navigation = 'true';
            if (isset($pagination) && $pagination == 'disable') {
                $navigation = 'false';
            }

            $flag = fw_unique_increment();

            $css = array();
            if (isset($margin_top) && !empty($margin_top)) {
                $css[] = 'margin-top:' . $margin_top . 'px;';
            }

            if (isset($margin_bottom) && !empty($margin_bottom)) {
                $css[] = 'margin-bottom:' . $margin_bottom . 'px;';
            }

            $image_src = '';

            if (isset($slide['url']) && !empty($slide['url'])) {
                $image_src = $slide['url'];
            }

            if (isset($v3_slides) && is_array($v3_slides) && !empty($v3_slides)) {
                dexterity_init_owl_script(); //OWL Carousel Init
                ?>
                <div class="tg-custom-slider" style="<?php echo implode(' ', $css); ?>">
                    <div id="tg-swiper-slider-<?php echo esc_attr($flag);?>" class="tg-swiper-slider swiper-container">
                        <div class="swiper-wrapper">
                            <?php
                            $counter = 0;
                            foreach ($v3_slides as $key => $value) {
                                $counter++;
                                $slide_banner = $value['slide_banner'];
                                $slide_title = $value['slide_title'];
                                $button_title = $value['button_title'];
                                $button_link = $value['button_link'];
                                $buy_button_title = $value['buy_button_title'];
                                $buy_button_link = $value['buy_button_link'];
                                ?>
                                <div class="swiper-slide">
                                    <figure>
                                        <?php if (isset($value['slide_banner']['url']) && !empty($value['slide_banner']['url'])) { ?>
                                            <img src="<?php echo esc_url($value['slide_banner']['url']); ?>" alt="<?php echo esc_attr($slide_title); ?>">
                                        <?php } ?>
                                        <figcaption>
                                            <?php if (isset($slide_title) && !empty($slide_title)) { ?>
                                                <div class="tg-theme-heading">
                                                    <h1><?php echo force_balance_tags($slide_title); ?></h1>
                                                </div>
                                            <?php } ?>
                                            <div class="tg-btnarea">
                                                <?php if (isset($button_title) && !empty($button_title)) { ?>
                                                    <a class="tg-btn" href="<?php echo esc_url($value['button_link']); ?>"><?php echo esc_attr($button_title); ?></a>
                                                <?php } ?>
                                                <?php if (isset($buy_button_title) && !empty($buy_button_title)) { ?>
                                                    <a class="tg-btn" href="<?php echo esc_url($value['buy_button_link']); ?>"><?php echo esc_attr($buy_button_title); ?></a>
                                                <?php } ?>
                                            </div>
                                        </figcaption>
                                    </figure>
                                </div>
                            <?php } ?>

                        </div>
                        <script>
                            jQuery(document).ready(function () {
                            var swiper = new Swiper('#tg-swiper-slider-<?php echo esc_js($flag);?>', {
                                pagination: '.swiper-pagination',
                                paginationClickable: true,
                                nextButton: '.swiper-button-next',
       							prevButton: '.swiper-button-prev',
                            });
                            });
                        </script>
                        <div class="swiper-pagination"></div>
                        <div class="swiper-button-prev"></div>
                        <div class="swiper-button-next"></div>
                    </div>

                </div>
                <?php
            }
        }

    }

    new SC_Slider();
}