<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
$uni_flag = fw_unique_increment();
$carousel_popup = $atts['carousel_popup'];
dexterity_init_owl_script();
?>
<div class="sc-carousel">
    <?php if (isset($carousel_popup) && !empty($carousel_popup)) { ?>
        <div id="tg-services-slider-<?php echo esc_attr($uni_flag); ?>" class="tg-services tg-services-slider tg-services2">
            <?php 
					$counter	= 0;
					foreach ($carousel_popup as $key => $carousel) {
					$counter++;	
				?>
                <div class="item">
                    <figure>
                        <div class="tg-expertise">
                            <?php if (isset($carousel['social_icons']) && !empty($carousel['social_icons'])) { ?>
                                <i class="<?php echo esc_attr($carousel['social_icons']); ?>"></i>
                            <?php } ?>
                            <?php if (isset($carousel['heading']) && !empty($carousel['heading'])) { ?>
                                <div class="tg-heading-border">
                                    <h3><?php echo esc_attr($carousel['heading']); ?></h3>
                                </div>
                            <?php } ?>
                        </div>
                        <?php if (isset($carousel['image']['url']) && !empty($carousel['image']['url'])) { ?>
                            <img src="<?php echo esc_url($carousel['image']['url']); ?>" alt="<?php the_title(); ?>">
                        <?php } ?>
                        <figcaption class="tg-img-hover">
                            <div class="tg-box">
                                <?php if (isset($carousel['description']) && !empty($carousel['heading'])) { ?>
                                    <div class="tg-description">
                                        <p><?php echo esc_attr($carousel['description']); ?></p>
                                    </div>
                                <?php } ?>
                                <div id="tg-services-skills<?php echo intval( $counter );?>" class="tg-skills tg-services-skills">
                                    <div class="tg-skill active">
                                        <?php if (isset($carousel['skill_level']) && !empty($carousel['skill_level'])) { ?>
                                            <span class="tg-skill-name"><?php echo esc_attr($carousel['skill_level']); ?></span>
                                        <?php } ?>
                                        <?php if (isset($carousel['percentage']) && !empty($carousel['percentage'])) { ?>
                                            <div class="tg-skill-holder" data-percent="<?php echo esc_attr($carousel['percentage']); ?>">
                                                <div class="tg-skill-bar"></div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </figcaption>
                    </figure>
                </div>
            <?php } ?>
            <script>
                /* -------------------------------------
                 SERVICES SLIDER
                 -------------------------------------- */
                jQuery(document).ready(function (e) {
                    jQuery("#tg-services-slider-<?php echo esc_js($uni_flag); ?>").owlCarousel({
                        items: 4,
                        autoPlay: false,
                        slideSpeed: 300,
                        pagination: false,
                        paginationSpeed: 400,
                        navigation: false,
                        itemsDesktop: [1199, 3],
                        itemsDesktopSmall: [991, 2],
                        itemsTablet: [767, 2],
                        itemsMobile: [568, 1]
                    });
                });

            </script>
        </div>
    <?php } ?>
</div>
