<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'counter_popup' => array(
        'type' => 'addable-popup',
        'label' => esc_html__('Add Counter', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
        'template' => '{{- counter_title }}',
        'popup-title' => null,
        'size' => 'small', // small, medium, large
        'limit' => 0, // limit the number of popup`s that can be added
        'add-button-text' => esc_html__('Counter', 'dexterity'),
        'sortable' => true,
        'popup-options' => array(
            'counter_title' => array(
                'label' => esc_html__('Counter Title', 'dexterity'),
                'type' => 'text',
                'value' => '',
                'desc' => esc_html__('Add counter title', 'dexterity'),
            ),
            'counter_start' => array(
                'label' => esc_html__('Start Number', 'dexterity'),
                'type' => 'text',
                'value' => '',
                'desc' => esc_html__('Add counter start', 'dexterity'),
            ),
            'counter_end' => array(
                'label' => esc_html__('End Number', 'dexterity'),
                'type' => 'text',
                'value' => '',
                'desc' => esc_html__('Add counter end', 'dexterity'),
            ),
            'counter_interval' => array(
                'type' => 'slider',
                'value' => 0,
                'properties' => array(
                    'min' => 0,
                    'max' => 50,
                    'sep' => 1,
                ),
                'attr' => array(),
                'label' => esc_html__('Interval', 'dexterity'),
                'desc' => esc_html__('add interval', 'dexterity'),
            ),
            'counter_speed' => array(
                'type' => 'slider',
                'value' => 0,
                'properties' => array(
                    'min' => 1000,
                    'max' => 10000,
                    'sep' => 1,
                ),
                'attr' => array(),
                'label' => esc_html__('Speed', 'dexterity'),
                'desc' => esc_html__('add speed', 'dexterity'),
            ),
        ),
    ),
);
