<?php

if (!defined('FW')) {
    die('Forbidden');
}
$options = array(
	'map_height' => array(
        'type' => 'text',
        'value' => '400',
        'label' => esc_html__('Map height', 'dexterity'),
        'desc' => esc_html__('Add height in PX as : 200, Default is 300', 'dexterity'),
    ),
	'latitude' => array(
        'type' => 'text',
        'value' => '-0.127758',
        'label' => esc_html__('Latitude', 'dexterity'),
        'desc' => esc_html__('Add Latitude', 'dexterity'),
    ),
    'longitude' => array(
        'type' => 'text',
        'value' => '51.507351',
        'label' => esc_html__('Longitude', 'dexterity'),
        'desc' => esc_html__('Add Longitude', 'dexterity'),
    ),
    'map_zoom' => array(
        'type' => 'slider',
        'value' => 16,
        'properties' => array(
            'min' => 0,
            'max' => 20,
            'sep' => 1,
        ),
        'attr' => array(),
        'label' => esc_html__('Zoom Level', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
    ),
	'map_type' => array(
        'type' => 'select',
        'choices' => array(
            'ROADMAP' => esc_html__('ROADMAP', 'dexterity'),
            'HYBRID' => esc_html__('HYBRID', 'dexterity'),
			'SATELLITE' => esc_html__('SATELLITE', 'dexterity'),
            'TERRAIN' => esc_html__('TERRAIN', 'dexterity'),
        ),
        'label' => esc_html__('Map Type', 'dexterity'),
        'desc' => esc_html__('Select map type.', 'dexterity'),
    ),
	'map_styles' => array(
        'type' => 'select',
        'choices' => array(
            'none' => esc_html__('NONE', 'dexterity'),
			'view_1' => esc_html__('Default', 'dexterity'),
			'view_2' => esc_html__('View 2', 'dexterity'),
			'view_3' => esc_html__('View 3', 'dexterity'),
			'view_4' => esc_html__('View 4', 'dexterity'),
			'view_5' => esc_html__('View 5', 'dexterity'),
			'view_6' => esc_html__('View 6', 'dexterity'),
        ),
        'label' => esc_html__('Map Style', 'dexterity'),
        'desc' => esc_html__('Select map style. It will override map type.', 'dexterity'),
    ),
	'map_info' => array(
        'type' => 'textarea',
        'value' => '',
        'label' => esc_html__('Map Infobox content', 'dexterity'),
        'desc' => esc_html__('Enter the marker content', 'dexterity'),
    ),
	'info_box_width' => array(
        'type' => 'text',
        'value' => '250',
        'label' => esc_html__('Map Infobox width', 'dexterity'),
        'desc' => esc_html__('Set max width for the google map info box', 'dexterity'),
    ),
	'info_box_height' => array(
        'type' => 'text',
        'value' => '150',
        'label' => esc_html__('Map Infobox height', 'dexterity'),
        'desc' => esc_html__('Set max height for the google map info box', 'dexterity'),
    ),
    'marker' => array(
        'type' => 'upload',
        'attr' => array(),
        'label' => esc_html__('Marker', 'dexterity'),
        'desc' => esc_html__('Add Map Marker', 'dexterity'),
    ),
    'map_controls' => array(
        'type' => 'select',
        'choices' => array(
            'true' => esc_html__('OFF', 'dexterity'),
            'false' => esc_html__('ON', 'dexterity'),
        ),
        'label' => esc_html__('Map Controls', 'dexterity'),
        'desc' => esc_html__('Select map controls.', 'dexterity'),
    ),
	'map_dragable' => array(
        'type' => 'select',
        'choices' => array(
            'true' => esc_html__('Yes', 'dexterity'),
            'false' => esc_html__('NO', 'dexterity'),
        ),
        'label' => esc_html__('Map Dragable', 'dexterity'),
        'desc' => esc_html__('Select map dragable?', 'dexterity'),
    ),
    'scroll' => array(
        'type' => 'select',
        'choices' => array(
            'false' => 'No',
            'true' => 'Yes',
        ),
        'label' => esc_html__('Scroll', 'dexterity'),
        'desc' => esc_html__('Enable/Disbale Mouse over scroll.', 'dexterity'),
    ),
);
