<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

/**
 * @var array $atts
 */

if ( empty( $atts['image'] ) ) {
	return;
}

$width  = ( is_numeric( $atts['width'] ) && ( $atts['width'] > 0 ) ) ? $atts['width'] : '';
$height = ( is_numeric( $atts['height'] ) && ( $atts['height'] > 0 ) ) ? $atts['height'] : '';
if ( ! empty( $width ) && ! empty( $height ) ) {
	$image = fw_resize( $atts['image']['attachment_id'], $width, $height, true );
} else {
	$image = $atts['image']['url'];
}

$image_frame_class = 'frame-img';

if(isset($atts['image_frame']) && $atts['image_frame'] == 'off'){
    $image_frame_class = 'frame-img-no';
}

?>
<div class="sc-imageframe">
<?php if ( empty( $atts['link'] ) ) : ?>
<figure class="tg-img-box <?php echo dexterity_esc_specialchars($image_frame_class); ?>"><img src="<?php echo esc_url( $image ) ?>" alt="<?php esc_html_e('Image Frame','dexterity');?>" /></figure>
<?php else : ?>
	<figure class="tg-img-box <?php echo dexterity_esc_specialchars($image_frame_class); ?>">
		<img src="<?php echo esc_url( $image ) ?>" alt="<?php esc_html_e('Image Frame','dexterity');?>" />
	</figure>
<?php endif ?>
</div>