<?php

if (!defined('FW')) {
    die('Forbidden');
}
$options = array(
    'heading' => array(
        'type' => 'text',
        'label' => esc_html__('Heading', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
    ),
    'main_description' => array(
        'label' => esc_html__('Description', 'dexterity'),
        'type' => 'textarea',
        'value' => '',
        'desc' => esc_html__('Add service description', 'dexterity'),
    ),
    'main_image' => array(
        'type' => 'upload',
        'value' => array(),
        'label' => esc_html__('Main Image', 'dexterity'),
        'desc' => esc_html__('Add Main Image', 'dexterity'),
    ),
    'services_popup' => array(
        'type' => 'addable-popup',
        'label' => esc_html__('Add Services', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
        'template' => '{{- title }}',
        'popup-title' => null,
        'size' => 'small', // small, medium, large
        'limit' => 0, // limit the number of popup`s that can be added
        'add-button-text' => esc_html__('Services', 'dexterity'),
        'sortable' => true,
        'popup-options' => array(
            'title' => array(
                'label' => esc_html__('Service Title', 'dexterity'),
                'type' => 'text',
                'value' => '',
                'desc' => esc_html__('Add service title', 'dexterity'),
            ),
            'services_icon' => array(
                'label' => esc_html__('Icons', 'dexterity'),
                'type' => 'new-icon',
                'value' => '',
                'desc' => esc_html__('Add service icons', 'dexterity'),
            ),
            'description' => array(
                'label' => esc_html__('Description', 'dexterity'),
                'type' => 'textarea',
                'value' => '',
                'desc' => esc_html__('Add service description', 'dexterity'),
            ),
            'image-posiion' => array(
                'type' => 'switch',
                'value' => 'show',
                'label' => esc_html__('Image Position', 'dexterity'),
                'desc' => esc_html__('Image Position', 'dexterity'),
                'right-choice' => array(
                    'value' => 'right',
                    'label' => esc_html__('Right Position', 'dexterity'),
                ),
                'left-choice' => array(
                    'value' => 'left',
                    'label' => esc_html__('Left Position', 'dexterity'),
                ),
            ),
            'image' => array(
                'type' => 'upload',
                'attr' => array(),
                'label' => esc_html__('Service Image', 'dexterity'),
                'desc' => esc_html__('Add Service Image', 'dexterity'),
            ),
            'link' => array(
                'type' => 'text',
                'value' => '#',
                'attr' => array(),
                'label' => esc_html__('Link', 'dexterity'),
                'desc' => esc_html__('Add Serices Link', 'dexterity'),
            ),
        ),
    ),
);
