<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'heading' => array(
        'type' => 'text',
        'label' => esc_html__('Heading', 'dexterity')
    ),
    'skill_description' => array(
        'type' => 'textarea',
        'label' => esc_html__('Description', 'dexterity')
    ),
    'skillset' => array(
        'type' => 'addable-popup',
        'label' => esc_html__('Skill Set', 'dexterity'),
        'popup-title' => esc_html__('Add Your Skill Set', 'dexterity'),
        'desc' => esc_html__('Add Your Skill Sets', 'dexterity'),
        'template' => '{{=skill_name}}',
        'popup-options' => array(
            'skill_highlight' => array(
                'type'  => 'checkbox',
                'value' => true, // checked/unchecked
                'attr'  => array(),
                'label' => esc_html__('Highlight', 'dexterity'),
                'desc'  => esc_html__('Highlight this skillset by check this box.', 'dexterity'),
                'text'  => esc_html__('Yes', 'dexterity'),
            ),
            'skill_name' => array(
                'type' => 'text',
                'label' => esc_html__('Skill Name', 'dexterity')
            ),
           'percentage' => array(
				'label' => esc_html__('Percentage', 'dexterity'),
				'type' => 'slider',
				'value' =>'86',
				'properties' => array(
					
					'min' => 0,
					'max' => 100,
					'step' => 1, // Set slider step. Always > 0. Could be fractional.
					
				),
			)
        ),
    )
);
