<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'tab_heading' => array(
        'type' => 'text',
        'label' => esc_html__('Tab Heading', 'dexterity')
    ),
    'tabs' => array(
        'type' => 'addable-popup',
        'label' => esc_html__('Tabs', 'dexterity'),
        'popup-title' => esc_html__('Add/Edit Tab', 'dexterity'),
        'desc' => esc_html__('Create your tabs', 'dexterity'),
        'template' => '{{=tab_title}}',
        'popup-options' => array(
            'tab_title' => array(
                'type' => 'text',
                'label' => esc_html__('Title', 'dexterity')
            ),
            'tab_image' => array(
                'type' => 'upload',
                'value' => array(),
                'label' => esc_html__('Image', 'dexterity'),
                'desc' => esc_html__('Upload Image', 'dexterity'),
            ),
            'tab_content' => array(
                'type' => 'wp-editor',
                'value' => '',
                'attr' => array(),
                'label' => esc_html__('Content', 'dexterity'),
                'desc' => esc_html__('', 'dexterity'),
                'help' => esc_html__('', 'dexterity'),
                /**
                 * Load TinyMCE, can be used to pass settings directly to TinyMCE using an array
                 * bool|array
                 */
                'tinymce' => true,
                /**
                 * Whether to display media insert/upload buttons
                 * boolean
                 */
                'media_buttons' => true,
                /**
                 * Whether to output the minimal editor configuration used in PressThis
                 * boolean
                 */
                'teeny' => true,
                /**
                 * Whether to use wpautop for adding in paragraphs
                 * boolean
                 */
                'wpautop' => true,
                /**
                 * Additional CSS styling applied for both visual and HTML editors buttons, needs to include <style> tags, can use "scoped"
                 * string
                 */
                'editor_css' => '',
                /**
                 * If smething goes wrong try set to true
                 * boolean
                 */
                'reinit' => true,
                /**
                 * Set the editor size: small - small box, large - full size
                 * boolean
                 */
                'size' => 'small', // small | large
                /**
                 * Set editor type : 'tinymce' or 'html'
                 */
                'editor_type' => 'tinymce',
                /**
                 * Set the editor height, must be int
                 */
                'editor_height' => 300
            )
        ),
    )
);
