<?php
if (!defined('FW')) {
    die('Forbidden');
}
/**
 * @var $atts
 */
$uni_flag = fw_unique_increment();
$teams = $atts['team_member'];
?>
<div class="sc-teams-grid">
    <div class="tg-section-head">
        <?php if (isset($atts['heading']) && !empty($atts['heading'])) { ?>
            <div class="tg-theme-heading">
                <h2><?php echo esc_attr($atts['heading']); ?></h2>
            </div>
        <?php } ?>
        <?php if (isset($atts['team_description']) && !empty($atts['team_description'])) { ?>
            <div class="tg-description">
                <p><?php echo esc_attr($atts['team_description']); ?></p>
            </div>
        <?php } ?>
    </div>
    <?php if (isset($atts['team_member'])) { ?>
        <?php foreach ($teams as $team_member) { ?>
            <div class="sc_team-grid">
                <div class="col-sm-4 col-xs-6 tg-teamwidth">
                    <div class="tg-member">
                        <figure>
                            <img src="<?php echo esc_url($team_member['avatar']['url']); ?>" alt="<?php the_title(); ?>">
                            <figcaption class="tg-img-hover">
                                <div class="tg-box tg-displayblock">
                                    <div class="tg-heading-border">
                                        <?php if (isset($team_member['designation']) && !empty($team_member['designation'])) { ?>
                                            <span class="tg-designation"><?php echo (esc_attr($team_member['designation'])); ?></span>
                                        <?php } ?>
                                        <?php
                                        if (isset($team_member['name']) && !empty($team_member['name'])) {
                                            if (isset($team_member['member_link']) && !empty($team_member['member_link'])) {
                                                $member_link = $team_member['member_link'];
                                            }
                                            ?>
                                            <h3><a href="<?php echo esc_url($member_link); ?>"><?php echo (esc_attr($team_member['name'])); ?></a></h3>
                                        <?php } ?>
                                    </div>
                                    <ul class="tg-socialicons tg-large">
                                        <?php
                                        foreach ($team_member['social_icons'] as $socials) {
                                            if (!empty($socials['icon'])) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_attr($socials['url']); ?>"><i class="<?php echo esc_attr($socials['icon']); ?>"></i></a>
                                                </li>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </figcaption>
                        </figure>
                    </div>
                </div>
            </div>
        <?php } ?>
    <?php } ?>
</div>
