<?php if ( ! defined( 'FW' ) ) {
    die( 'Forbidden' );
}

$options = array(
    'sub_headers' => array(
		'title'   => esc_html__( 'Page Settings', 'dexterity' ),
		'type'    => 'box',
		'options' => array(
			'enable_subheader' => array(
				'type'  => 'switch',
				'value' => 'enable',
				'label' => esc_html__('Subheader', 'dexterity'),
				'desc'  => esc_html__('Enable or Disable Subheader', 'dexterity'),
				'left-choice' => array(
					'value' => 'enable',
					'label' => esc_html__('Enable', 'dexterity'),
				),
				'right-choice' => array(
					'value' => 'disable',
					'label' => esc_html__('Disable', 'dexterity'),
				),
			),
			'subheader_type' => array(
				'type'         => 'multi-picker',
				'label'        => false,
				'desc'         => false,
				'picker'       => array(
					'gadget' => array(
						'label'   => esc_html__( 'Subheader Type', 'dexterity' ),
						'desc'   => esc_html__( 'Select Subheader Type', 'dexterity' ),
						'type'    => 'select',
						'choices' => array(
							'default' => esc_html__('Default Sub Headers', 'dexterity'),
							'custom' => esc_html__('Custom Sub Headers', 'dexterity'),
							'tg_slider' => esc_html__('TG Slider', 'dexterity'),
							'rev_slider' => esc_html__('Revolution Slider', 'dexterity'),
							'custom_shortcode' => esc_html__('Custom Shortcode', 'dexterity'),	
						)
					)
				),
				'choices'      => array(
					'default'  => array(
						'blog_post_image' => array(
							'type' => 'html',
							'html' => 'Default Subheaders',
							'label' => esc_html__('', 'dexterity'),
							'desc' => esc_html__('Please default settings from theme options.', 'dexterity'),
							'help' => esc_html__('Please Go To Appearance >> Theme Settings >> Subheaders', 'dexterity'),
							'images_only' => true,
						),
					),
					'custom'  => array(
						'enable_breadcrumbs' => array(
							'type'  => 'switch',
							'value' => 'enable',
							'label' => esc_html__('Breadcrumbs', 'dexterity'),
							'desc'  => esc_html__('Enable or Disable Breadcrumbs.', 'dexterity'),
							'left-choice' => array(
								'value' => 'enable',
								'label' => esc_html__('Enable', 'dexterity'),
							),
							'right-choice' => array(
								'value' => 'disable',
								'label' => esc_html__('Disable', 'dexterity'),
							),
						),
						'sub_header_bg' => array(
							'type'  => 'rgba-color-picker',
							'value' => 'rgba(255,255,255,0)',
							'label' => esc_html__('Sub Header bg color', 'dexterity'),
							'desc'  => esc_html__('', 'dexterity'),
						),
						'subheader_bg_image' => array(
							'type'  => 'upload',
							'label' => esc_html__('Upload background image', 'dexterity'),
							'desc'  => esc_html__('It will override background color', 'dexterity'),
							'images_only' => true,
						),
					),
					'tg_slider'  => array(
						'sub_shortcode' => array(
							'type'  => 'select',
							'value' => '',
							'label' => esc_html__('TG Slider', 'dexterity'),
							'desc'  => esc_html__('Select Themographic Slider.', 'dexterity'),
							'choices' => dexterity_prepare_sliders(),
						),
					),
					'rev_slider'  => array(
						'rev_slider' => array(
							'type'  => 'select',
							'value' => '',
							'label' => esc_html__('Revolution Slider', 'dexterity'),
							'desc'  => esc_html__('Please Select Revolution slider.', 'dexterity'),
							'help' => esc_html__('Please install revolution slider first.', 'dexterity'),
							'choices' => dexterity_prepare_rev_slider(),
						),
					),
					'custom_shortcode'  => array(
						'custom_shortcode' => array(
							'type'  => 'textarea',
							'value' => '',
							'desc' => esc_html__('', 'dexterity'),
							'label'  => esc_html__('Custom Slider', 'dexterity'),
						),
					),
				)
			),
		)
	),
);