<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'subheader' => array(
		'title'   => esc_html__( 'Sub Header Settings', 'dexterity' ),
		'type'    => 'box',
		'options' => array(
			'enable_subheader' => array(
				'type'  => 'switch',
				'value' => 'enable',
				'label' => esc_html__('Subheader', 'dexterity'),
				'desc'  => esc_html__('Enable or Disable Subheader', 'dexterity'),
				'left-choice' => array(
					'value' => 'enable',
					'label' => esc_html__('Enable', 'dexterity'),
				),
				'right-choice' => array(
					'value' => 'disable',
					'label' => esc_html__('Disable', 'dexterity'),
				),
			),
			'subheader_type' => array(
		'type'         => 'multi-picker',
		'label'        => false,
		'desc'         => false,
		'picker'       => array(
			'gadget' => array(
				'label'   => esc_html__( 'Subheader Type', 'dexterity' ),
				'desc'   => esc_html__( 'Select Subheader Type', 'dexterity' ),
				'type'    => 'select',
				'choices' => array(
					'default' => esc_html__('Default Sub Headers', 'dexterity'),
					'custom' => esc_html__('Custom Sub Headers', 'dexterity'),
					'tg_slider' => esc_html__('TG Slider', 'dexterity'),
					'rev_slider' => esc_html__('Revolution Slider', 'dexterity'),
					'custom_shortcode' => esc_html__('Custom Shortcode', 'dexterity'),	
				)
			)
		),
		'choices'      => array(
			'default'  => array(
				'blog_post_image' => array(
					'type' => 'html',
					'html' => 'Default Subheaders',
					'label' => esc_html__('', 'dexterity'),
					'desc' => esc_html__('Please set default settings from theme options.', 'dexterity'),
					'help' => esc_html__('Please Go To Appearance >> Theme Settings >> Subheaders', 'dexterity'),
					'images_only' => true,
				),
			),
			'custom'  => array(
				'enable_breadcrumbs' => array(
					'type'  => 'switch',
					'value' => 'enable',
					'label' => esc_html__('Breadcrumbs', 'dexterity'),
					'desc'  => esc_html__('Enable or Disable Breadcrumbs.', 'dexterity'),
					'left-choice' => array(
						'value' => 'enable',
						'label' => esc_html__('Enable', 'dexterity'),
					),
					'right-choice' => array(
						'value' => 'disable',
						'label' => esc_html__('Disable', 'dexterity'),
					),
				),
				'subheader_bg_image' => array(
					'type'  => 'upload',
					'label' => esc_html__('Upload background image', 'dexterity'),
					'desc'  => esc_html__('It will override background color', 'dexterity'),
					'images_only' => true,
				),
				'sub_header_bg' => array(
					'type'  => 'rgba-color-picker',
					'value' => 'rgba(255,255,255,0)',
					'label' => esc_html__('Sub Header bg color', 'dexterity'),
					'desc'  => esc_html__('Please Note that this color will override background image. If you want to set color over the image then please set as RGBA, for example: rgba(255,255,255,0)', 'dexterity'),
				),
				'sub_heading_text' => array(
					'type'  => 'color-picker',
					'value' => '#FFF',
					'label' => esc_html__('Sub Heading Text color', 'dexterity'),
					'desc'  => esc_html__('', 'dexterity'),
				),
			),
			'tg_slider'  => array(
				'sub_shortcode' => array(
					'type'  => 'select',
					'value' => '',
					'label' => esc_html__('TG Slider', 'dexterity'),
					'desc'  => esc_html__('Select Themographic Slider.', 'dexterity'),
					'choices' => dexterity_prepare_sliders(),
				),
			),
			'rev_slider'  => array(
				'rev_slider' => array(
					'type'  => 'select',
					'value' => '',
					'label' => esc_html__('Revolution Slider', 'dexterity'),
					'desc'  => esc_html__('Please Select Revolution slider.', 'dexterity'),
					'help' => esc_html__('Please install revolution slider first.', 'dexterity'),
					'choices' => dexterity_prepare_rev_slider(),
				),
			),
			'custom_shortcode'  => array(
				'custom_shortcode' => array(
					'type'  => 'textarea',
					'value' => '',
					'desc' => esc_html__('', 'dexterity'),
					'label'  => esc_html__('Custom Slider', 'dexterity'),
				),
			),
		)
	),
		)
	),
	'post_settings' => array(
		'title' => esc_html__('Post Settings', 'dexterity'),
		'type' => 'box',
		'options' => array(
			'enable_auhtor_info' => array(
				'type'  => 'switch',
				'value' => 'disable',
				'label' => esc_html__('Author Information', 'dexterity'),
				'desc'  => esc_html__('Enable or Disable Author Information at post detail page.', 'dexterity'),
				'left-choice' => array(
					'value' => 'enable',
					'label' => esc_html__('Enable', 'dexterity'),
				),
				'right-choice' => array(
					'value' => 'disable',
					'label' => esc_html__('Disable', 'dexterity'),
				),
			),
			'post_settings' => array(
				'type'         => 'multi-picker',
				'label'        => false,
				'desc'         => false,
				'picker'       => array(
					'gadget' => array(
						'label'   => esc_html__( 'Post Format', 'dexterity' ),
						'desc'   => esc_html__( 'Select Post Format', 'dexterity' ),
						'type'    => 'radio',
						'value'    => 'image',
						'choices' => array(
							'image' => esc_html__('Image', 'dexterity'),
							'gallery' => esc_html__('Image Slider', 'dexterity'),
							'video' => esc_html__('Audio/Video', 'dexterity'),
						),
						'inline' => true,
					)
				),
				'choices'      => array(
					'image'  => array(
						'blog_post_image' => array(
							'type' => 'html',
							'html' => 'Featured Image',
							'label' => esc_html__('', 'dexterity'),
							'desc' => esc_html__('Please add featured image.', 'dexterity'),
							'help' => esc_html__('Add Featured image for this post.', 'dexterity'),
							'images_only' => true,
						),
					),
					'gallery'  => array(
						'blog_post_gallery' => array(
							'type' => 'multi-upload',
							'label' => esc_html__('Add Image Slider', 'dexterity'),
							'desc' => esc_html__('Add Image Slider for your post. (Preferred Size is 1314 by 737.)', 'dexterity'),
							'help' => esc_html__('Only worked if the post format setting is equal to image slider.', 'dexterity'),
							'images_only' => true,
						),
					),
					'video'  => array(
						'blog_video_link' => array(
							'type' => 'text',
							'label' => esc_html__('Audio/Video Link', 'dexterity'),
							'desc' => esc_html__('Only worked if the post format setting is equal to Audio/Video.', 'dexterity'),
						),
					),
				)
			),
		)
	), 
);
