<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'settings' => array(
        'title' => 'Slider Settings',
        'type' => 'box',
        'options' => array(
            'margin_top' => array(
                'type' => 'slider',
                'value' => 0,
                'properties' => array(
                    'min' => -500,
                    'max' => 500,
                    'sep' => 1,
                ),
                'label' => esc_html__('Margin Top', 'dexterity'),
            ),
            'margin_bottom' => array(
                'type' => 'slider',
                'value' => 0,
                'properties' => array(
                    'min' => -500,
                    'max' => 500,
                    'sep' => 1,
                ),
                'label' => esc_html__('Margin Bottom', 'dexterity'),
            ),
            'pagination' => array(
                'type' => 'switch',
                'value' => 'enable',
                'label' => esc_html__('Enable Pagination', 'dexterity'),
                'desc' => esc_html__('Enable or Disable Pagination.', 'dexterity'),
                'left-choice' => array(
                    'value' => 'enable',
                    'label' => esc_html__('Enable', 'dexterity'),
                ),
                'right-choice' => array(
                    'value' => 'disable',
                    'label' => esc_html__('Disable', 'dexterity'),
                ),
            ),
            'auto' => array(
                'type' => 'switch',
                'value' => 'enable',
                'label' => esc_html__('Auto Start', 'dexterity'),
                'desc' => esc_html__('Enable or Disable Auto Start.', 'dexterity'),
                'left-choice' => array(
                    'value' => 'enable',
                    'label' => esc_html__('Enable', 'dexterity'),
                ),
                'right-choice' => array(
                    'value' => 'disable',
                    'label' => esc_html__('Disable', 'dexterity'),
                ),
            ),
            'custom_classes' => array(
                'label' => esc_html__('Classes', 'dexterity'),
                'type' => 'text',
                'desc' => esc_html__('Add you custom classes.', 'dexterity'),
            ),
            'slider_type' => array(
                'type' => 'multi-picker',
                'label' => false,
                'desc' => false,
                'picker' => array(
                    'gadget' => array(
                        'label' => esc_html__('Select Slider Type', 'dexterity'),
                        'type' => 'image-picker',
                        'choices' => array(
                            'slider_v1' => array(
                                'label' => esc_html__('Slider V1', 'dexterity'),
                                'small' => array(
                                    'height' => 70,
                                    'src' => get_template_directory_uri() . '/images/slider_types/slider_1_large.jpg'
                                ),
                                'large' => array(
                                    'height' => 214,
                                    'src' => get_template_directory_uri() . '/images/slider_types/slider_1_large.jpg'
                                ),
                            ),
                            'slider_v2' => array(
                                'label' => esc_html__('Slider V2', 'dexterity'),
                                'small' => array(
                                    'height' => 70,
                                    'src' => get_template_directory_uri() . '/images/slider_types/slider_2_large.jpg'
                                ),
                                'large' => array(
                                    'height' => 214,
                                    'src' => get_template_directory_uri() . '/images/slider_types/slider_2_large.jpg'
                                ),
                            ),
                            'slider_v3' => array(
                                'label' => esc_html__('Slider V3', 'dexterity'),
                                'small' => array(
                                    'height' => 70,
                                    'src' => get_template_directory_uri() . '/images/slider_types/slider_3_large.jpg'
                                ),
                                'large' => array(
                                    'height' => 214,
                                    'src' => get_template_directory_uri() . '/images/slider_types/slider_3_large.jpg'
                                ),
                            )
                        ),
                        'desc' => esc_html__('', 'dexterity'),
                    )
                ),
                'choices' => array(
                    'slider_v1' => array(
                        'v1_slides' => array(
                            'title' => false,
                            'type' => 'box',
                            'options' => array(
                                'carousel_slides' => array(
                                    'type' => 'addable-popup',
                                    'label' => esc_html__('Add slides', 'dexterity'),
                                    'template' => '{{- slide_title }}',
                                    'popup-title' => null,
                                    'size' => 'small', // small, medium, large
                                    'limit' => 0, // limit the number of popup`s that can be added
                                    'popup-options' => array(
                                        'slide_banner' => array(
                                            'type' => 'upload',
                                            'label' => esc_html__('Banner Image', 'dexterity'),
                                            'desc' => esc_html__('Upload your slider banner image.', 'dexterity'),
                                            'images_only' => true,
                                        ),
                                        'slide_title' => array(
                                            'label' => esc_html__('Title', 'dexterity'),
                                            'type' => 'text',
                                            'value' => 'Weekend Special',
                                            'desc' => esc_html__('Enter Slider title.', 'dexterity'),
                                        ),
                                        'button_title' => array(
                                            'label' => esc_html__('Button Title', 'dexterity'),
                                            'type' => 'text',
                                            'value' => 'read more',
                                            'desc' => esc_html__('Enter button title, leave it empty to hide.', 'dexterity'),
                                        ),
                                        'button_link' => array(
                                            'label' => esc_html__('Link', 'dexterity'),
                                            'type' => 'text',
                                            'value' => '#',
                                            'desc' => esc_html__('', 'dexterity'),
                                        ),
                                        
                                    ),
                                ),
                            )
                        ),
                    ),
                    'slider_v2' => array(
                        'v2_slides' => array(
                            'title' => false,
                            'type' => 'box',
                            'options' => array(
                                'carousel_slides' => array(
                                    'type' => 'addable-popup',
                                    'label' => esc_html__('Add slides', 'dexterity'),
                                    'template' => '{{- slide_title }}',
                                    'popup-title' => null,
                                    'size' => 'small', // small, medium, large
                                    'limit' => 0, // limit the number of popup`s that can be added
                                    'popup-options' => array(
                                        'slide_banner' => array(
                                            'type' => 'upload',
                                            'label' => esc_html__('Upload Banner Image', 'dexterity'),
                                            'desc' => esc_html__('Upload your slider banner image.', 'dexterity'),
                                            'images_only' => true,
                                        ),
                                        'slide_title' => array(
                                            'label' => esc_html__('Title', 'dexterity'),
                                            'type' => 'text',
                                            'desc' => esc_html__('Enter Slider title.', 'dexterity'),
                                        ),
                                        
                                        'button_title' => array(
                                            'label' => esc_html__('Button Title', 'dexterity'),
                                            'value' => 'More Detail',
                                            'type' => 'text',
                                            'desc' => esc_html__('Enter Button Title.', 'dexterity'),
                                        ),
                                        'button_link' => array(
                                            'label' => esc_html__('link', 'dexterity'),
                                            'type' => 'text',
                                            'value' => '#',
                                            'desc' => esc_html__('Enter link.', 'dexterity'),
                                        ),
                                    ),
                                ),
                            )
                        ),
                    ),
                    'slider_v3' => array(
                        'v3_slides' => array(
                            'title' => false,
                            'type' => 'box',
                            'options' => array(
                                'carousel_slides' => array(
                                    'type' => 'addable-popup',
                                    'label' => esc_html__('Add slides', 'dexterity'),
                                    'template' => '{{- slide_title }}',
                                    'popup-title' => null,
                                    'size' => 'small', // small, medium, large
                                    'limit' => 0, // limit the number of popup`s that can be added
                                    'popup-options' => array(
                                        'slide_banner' => array(
                                            'type' => 'upload',
                                            'label' => esc_html__('Upload Banner Image', 'dexterity'),
                                            'desc' => esc_html__('Upload your slider banner image.', 'dexterity'),
                                            'images_only' => true,
                                        ),
                                        'slide_title' => array(
                                            'label' => esc_html__('Title', 'dexterity'),
                                            'type' => 'text',
                                            'desc' => esc_html__('Enter Slider title.', 'dexterity'),
                                        ),
                                       
                                        'button_title' => array(
                                            'label' => esc_html__('Button Title', 'dexterity'),
                                            'value' => 'More Detail',
                                            'type' => 'text',
                                            'desc' => esc_html__('Enter Button Title.', 'dexterity'),
                                        ),
                                        'button_link' => array(
                                            'label' => esc_html__('link', 'dexterity'),
                                            'type' => 'text',
                                            'value' => '#',
                                            'desc' => esc_html__('Enter link.', 'dexterity'),
                                        ),
                                         'buy_button_title' => array(
                                            'label' => esc_html__('Buy Button Title', 'dexterity'),
                                            'value' => 'Buy More',
                                            'type' => 'text',
                                            'desc' => esc_html__('Enter Buy Button Title.', 'dexterity'),
                                        ),
                                         'buy_button_link' => array(
                                            'label' => esc_html__('Buy Button Link', 'dexterity'),
                                            'value' => '#',
                                            'type' => 'text',
                                            'desc' => esc_html__('Enter Buy Button Link.', 'dexterity'),
                                        )
                                    ),
                                ),
                            )
                        ),
                    ),
                ),
                'show_borders' => true,
            ),
        )
    ),
);
