<?php
/**
 * @Class headers
 *
 */
if (!class_exists('dexterity_headers')) {

    class dexterity_headers {

        function __construct() {
            add_action('dexterity_init_headers', array(&$this, 'dexterity_init_headers'));
            add_action('dexterity_prepare_topstrop', array(&$this, 'dexterity_prepare_topstrop'));
            add_action('dexterity_prepare_header', array(&$this, 'dexterity_prepare_header'));
        }

        /**
         * @Init Headers
         * @return {}
         */
        public function dexterity_init_headers() {
            $post_name = dexterity_get_post_name();
            if (function_exists('fw_get_db_settings_option')) {
                $maintenance = fw_get_db_settings_option('maintenance');
                $transparent_header = fw_get_db_settings_option('transparent_header');
                $sticky_header = fw_get_db_settings_option('sticky_header');
            } else {
                $maintenance = '';
                $transparent_header = '';
                $sticky_header = '';
            }

           $headerClass = 'header1';
            if (isset($transparent_header) && $transparent_header === 'enable') {
                $headerClass = 'header2';
            }


            if ($post_name === 'home2') {
                $headerClass = 'header2'; //just for demo
            }
            
            $loaderDisbale = '';

            if (function_exists('fw_get_db_settings_option')) {
                $site_loader = fw_get_db_settings_option('preloader');
            }

            if (( isset($maintenance) && $maintenance == 'enable' && !is_user_logged_in() ) || $post_name === "coming-soon") {
                $loaderDisbale = 'style=display:none;';
            }

            get_template_part('template-parts/template', 'comingsoon'); //Coming Soon

            $site_loader = '';

            if (function_exists('fw_get_db_settings_option')) {
                $site_loader = fw_get_db_settings_option('preloader');
            }


            if (isset($site_loader) && $site_loader === 'enable') {
                ?>
                <div id="status">
                    <div id="preloader" class="">
                        <img src="<?php echo get_template_directory_uri();?>/images/preloader.gif" alt="<?php echo esc_attr( 'Preloader','dexterity' );?>" />
                    </div>
                </div>
            <?php } ?>
            <div id="wrapper" class="tg-haslayout">
                <header id="header" class="tg-haslayout">
                    <?php do_action('dexterity_prepare_topstrop'); ?>
                    <?php do_action('dexterity_prepare_header'); ?>
                </header>
                <?php do_action('dexterity_prepare_subheaders'); ?>
                <main id="main" class="inner-main-content tg-haslayout">
                    <?php
                }

                /**
                 * @Prepare Top Strip
                 * @return {}
                 */
                public function dexterity_prepare_topstrop() {
                    $top_strip = '';
                    $email = '';
                    $phone = '';
                    $social_icons = '';
                    $enable_social = '';

                    if (function_exists('fw_get_db_settings_option')) {
                        $top_strip = fw_get_db_settings_option('top_strip');
                        $email = fw_get_db_settings_option('strip_email');
                        $phone = fw_get_db_settings_option('strip_phone');
                        $social_icons = fw_get_db_settings_option('social_icons');
                        $enable_social = fw_get_db_settings_option('enable_social');
                    }

                    $post_name = dexterity_get_post_name();

                    if ($post_name === 'home2') {
                        $top_strip = 'disbale'; //just for demo
                    }

                    ob_start();
                    ?>
                    <?php if ($top_strip === 'enable') { ?>
                        <div class="tg-topbar">
                            <div class="container">
                                <div class="row">

                                    <div class="col-md-6 col-sm-4 col-xs-4">
                                        <?php if (isset($social_icons) && !empty($social_icons) && isset($enable_social) && $enable_social === 'enable') { ?>
                                            <ul class="tg-socialicons">
                                                <?php
                                                foreach ($social_icons as $icon) {
                                                    $social_url = '';
                                                    if (isset($icon['social_url']) && !empty($icon['social_url'])) {
                                                        $social_url = $icon['social_url'];
                                                    }
                                                    if (isset($icon['social_icons_list']) && !empty($icon['social_icons_list'])) {
                                                        $social_icon = $icon['social_icons_list'];
                                                        ?>
                                                        <li><a href="<?php echo esc_url($social_url); ?>"><i class="<?php echo esc_attr($social_icon) ?>"></i></a></li>
                                                    <?php }
                                                } ?>
                                            </ul>
                                        <?php } ?>
                                    </div>

                                    <div class="col-md-6 col-sm-8 col-xs-8">
                                        <ul class="tg-contact-info">
                                            <?php if (isset($email) && !empty($email)) { ?>
                                                <li>
                                                    <i class="fa fa-envelope-o"></i><a href="info@company.com"><?php echo esc_attr($email) ?></a>
                                                </li>
                                            <?php } ?>
                                            <?php if (isset($phone) && !empty($phone)) { ?>
                                                <li>
                                                    <i class="fa fa-phone"></i><em><?php echo esc_attr($phone); ?></em>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <?php
                    echo ob_get_clean();
                }

                /**
                 * @Header
                 * @return {}
                 */
                public function dexterity_prepare_header() {
                    $main_logo = '';
                    $hire = '';
                    $headerClass = '';
                    $post_name = dexterity_get_post_name();

                    if (function_exists('fw_get_db_settings_option')) {
                        $main_logo = fw_get_db_settings_option('main_logo');
                        $hire = fw_get_db_settings_option('hire_botton');
                    }
                    ob_start();
                    if (isset($main_logo) && !empty($main_logo)) {
                        $logo = $main_logo['url'];
                    } else {
                        $logo = get_template_directory_uri() . '/images/logo.png';
                    }

                    if (isset($post_name) && $post_name === 'home2') {
                        $logo = get_template_directory_uri() . '/images/logo2.png'; // just for demo
                    }
                    ?>
                    <div class="tg-navigationarea">
                        <div class="container">
                            <div class="row">
                                <div class="col-xs-12">
                                    <strong class="tg-logo">
                                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($logo); ?>" alt="<?php the_title(); ?>"></a>
                                    </strong>
                                    <div class="tg-rightarea">
                                        <?php if (isset($hire) && $hire === 'enable') { ?>
                                            <nav class="tg-addnav">
                                                <ul>
                                                    <li>
                                                        <a href="javascript:void(0);" data-toggle="modal" data-target=".tg-login-lightbox">
                                                            <i class="fa fa-user-plus"></i>
                                                            <em><?php esc_html_e('Hire now', 'dexterity'); ?></em>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </nav>
                                        <?php } ?>
                                        <nav id="tg-nav" class="tg-nav">
                                            <div class="navbar-header">
                                                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#tg-navigation" aria-expanded="false">
                                                    <span class="sr-only"><?php esc_html_e('Toggle navigation', 'dexterity'); ?></span>
                                                    <span class="icon-bar"></span>
                                                    <span class="icon-bar"></span>
                                                    <span class="icon-bar"></span>
                                                </button>
                                            </div>
                                            <div id="tg-navigation" class="tg-navigation collapse navbar-collapse">
                                                <span class="tg-close fa fa-close"></span>
                                                <?php $this->dexterity_prepare_navigation($location = 'main-menu', $id = 'menus', $class = '', $depth = '0') ?>
                                            </div>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    echo ob_get_clean();
                }

                /**
                 * @Main Navigation
                 * @return {}
                 */
                public static function dexterity_prepare_navigation($location = '', $id = 'menus', $class = '', $depth = '0') {

                    if (has_nav_menu($location)) {
                        $defaults = array(
                            'theme_location' => "$location",
                            'menu' => '',
                            'container' => '',
                            'container_class' => '',
                            'container_id' => '',
                            'menu_class' => "$class",
                            'menu_id' => "$id",
                            'echo' => false,
                            'fallback_cb' => 'wp_page_menu',
                            'before' => '',
                            'after' => '',
                            'link_before' => '',
                            'link_after' => '',
                            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth' => "$depth",
                                //'walker' => new Dexterity_Menu_Walker
                        );
                        echo do_shortcode(wp_nav_menu($defaults));
                    } else {
                        $defaults = array(
                            'theme_location' => "",
                            'menu' => '',
                            'container' => '',
                            'container_class' => '',
                            'container_id' => '',
                            'menu_class' => "$class",
                            'menu_id' => "$id",
                            'echo' => false,
                            'fallback_cb' => 'wp_page_menu',
                            'before' => '',
                            'after' => '',
                            'link_before' => '',
                            'link_after' => '',
                            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth' => "$depth",
                            'walker' => '');
                        echo do_shortcode(wp_nav_menu($defaults));
                    }
                }

            }

            new dexterity_headers();
        }