<?php
/**
 * Theme Helper Functions
 *
 * @package Dexterity
 */
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
if (!isset($content_width)) {
    $content_width = 640; /* pixels */
}
/**
 * @Theme Editor Style
 * 
 */
if (!function_exists('dexterity_add_editor_styles')) {

    function dexterity_add_editor_styles() {
        $theme_version = wp_get_theme();
        add_editor_style(get_template_directory_uri() . '/core/css/dexterity-editor-style.css', array(), $theme_version->get('Version'));
    }

    add_action('admin_init', 'dexterity_add_editor_styles');
}

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
if (!function_exists('dexterity_widgets_init')) {

    function dexterity_widgets_init() {

        register_sidebar(array(
            'name' => esc_attr('Sidebar', 'dexterity'),
            'id' => 'sidebar-1',
            'description' => '',
            'before_widget' => '<div id="%1$s" class="tg-widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Shop Sidebar', 'dexterity'),
            'id' => 'shop_sidebar',
            'description' => '',
            'before_widget' => '<div id="%1$s" class="tg-widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>',
        ));

        register_sidebar(array(
            'name' => esc_html__('Footer Column 1', 'dexterity'),
            'id' => 'footer-column-1',
            'description' => '',
            'before_widget' => '<div id="%1$s" class="%2$s column-widget">',
            'after_widget' => '</div>',
            'before_title' => '<div class="tg-heading-border"><h3>',
            'after_title' => '</h3></div>',
        ));
        register_sidebar(array(
            'name' => esc_html__('Footer Column 2', 'dexterity'),
            'id' => 'footer-column-2',
            'description' => '',
            'before_widget' => '<div id="%1$s" class="%2$s column-widget">',
            'after_widget' => '</div>',
            'before_title' => '<div class="tg-heading-border"><h3>',
            'after_title' => '</h3></div>',
        ));
        register_sidebar(array(
            'name' => esc_html__('Footer Column 3', 'dexterity'),
            'id' => 'footer-column-3',
            'description' => '',
            'before_widget' => '<div id="%1$s" class="%2$s column-widget">',
            'after_widget' => '</div>',
            'before_title' => '<div class="tg-heading-border"><h3>',
            'after_title' => '</h3></div>',
        ));
    }

    add_action('widgets_init', 'dexterity_widgets_init');
}

/**
 * Enqueue scripts and styles.
 */
if (!function_exists('dexterity_scripts')) {

    function dexterity_scripts() {
        $theme_version = wp_get_theme();

        //Theme general styles
        wp_enqueue_style('bootstrap.min', get_template_directory_uri() . '/css/bootstrap.min.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('dexterity_normalize', get_template_directory_uri() . '/css/normalize.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('dexterity_style', get_template_directory_uri() . '/style.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('fontawesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('icomoon', get_template_directory_uri() . '/css/icomoon.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('prettyPhoto', get_template_directory_uri() . '/css/prettyPhoto.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('final-countdown', get_template_directory_uri() . '/css/final-countdown.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('dexterity_theme_swiper', get_template_directory_uri() . '/css/swiper.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('owl.theme', get_template_directory_uri() . '/css/owl.theme.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('dexterity_transitions', get_template_directory_uri() . '/css/transitions.css', array(), $theme_version->get('Version'));
		wp_enqueue_style('dexterity_typo', get_template_directory_uri() . '/css/typo.css', array(), $theme_version->get('Version'));
        wp_enqueue_style('dexterity_responsive_style', get_template_directory_uri() . '/css/responsive.css', array(), $theme_version->get('Version'));
		


        if (function_exists('fw_get_db_post_option')) {
            $theme_type = fw_get_db_settings_option('theme_type');
        } else {
            $theme_type = '';
        }
		
        wp_enqueue_style('dexterity_theme_colors', get_template_directory_uri() . '/css/color.css', array(), $theme_version->get('Version'));

        //Theme general scripts
        wp_enqueue_script('bootstrap.min', get_template_directory_uri() . '/js/vendor/bootstrap.min.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('prettyPhoto', get_template_directory_uri() . '/js/prettyPhoto.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('isotope.pkgd', get_template_directory_uri() . '/js/isotope.pkgd.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('swiper', get_template_directory_uri() . '/js/swiper.min.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('isotop', get_template_directory_uri() . '/js/isotop.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('parallax', get_template_directory_uri() . '/js/parallax.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('countTo', get_template_directory_uri() . '/js/countTo.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('appear', get_template_directory_uri() . '/js/appear.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_script('dexterity_functions', get_template_directory_uri() . '/js/dexterity_scripts.js', array('jquery'), $theme_version->get('Version'), true);
        wp_enqueue_script('final-countdown', get_template_directory_uri() . '/js/jquery.final-countdown.js', array(), $theme_version->get('Version'), false);
        wp_enqueue_script('kinetic', get_template_directory_uri() . '/js/kinetic.js', array(), $theme_version->get('Version'), false);
        wp_enqueue_script('modernizr', get_template_directory_uri() . '/js/vendor/modernizr-2.8.3-respond-1.4.2.min.js', array(), $theme_version->get('Version'), true);


		
		if (function_exists('fw_get_db_post_option')) {
            $sticky_header = fw_get_db_settings_option('sticky_header');
        } else {
            $sticky_header = '';
        }
		

        wp_localize_script('dexterity_functions', 'scripts_vars', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
			'is_sticky' => $sticky_header,
        ));

        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }

        if (function_exists('fw_get_framework_directory_uri')) :
            if (!is_admin()) {
                wp_enqueue_script(
                        'fw-form-helpers', fw_get_framework_directory_uri('/static/js/fw-form-helpers.js')
                );
            }
        endif;
    }

    add_action('wp_enqueue_scripts', 'dexterity_scripts');
}

/**
 * Enqueue scripts and styles.
 */
if (!function_exists('dexterity_admin_scripts')) {

    function dexterity_admin_scripts() {
        $theme_version = wp_get_theme();
        wp_enqueue_media();
        wp_enqueue_style('dexterity_font_awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), $theme_version->get('Version'));
        wp_enqueue_script('dexterity_admin_functions', get_template_directory_uri() . '/core/js/dexterity_admin_functions.js', array('jquery'), $theme_version->get('Version'), true);

        //Styles
        wp_enqueue_style('dexterity_admin_styles', get_template_directory_uri() . '/core/css/admin_styles.css', array(), $theme_version->get('Version'));
    }

    add_action('admin_enqueue_scripts', 'dexterity_admin_scripts');
}
/**
 * @Init Sharing Script
 * @return 
 */
if (!function_exists('dexterity_init_share_script')) {

    function dexterity_init_share_script() {
        wp_enqueue_script('dexterity_addthis', 'http://s7.addthis.com/js/250/addthis_widget.js#pubid=xa-4e4412d954dccc64', '', '', true);
    }

}

/**
 * @Init Sharing Script
 * @return 
 */
if (!function_exists('dexterity_init_datepicker_script')) {

    function dexterity_init_datepicker_script() {
        $theme_version = wp_get_theme();
        wp_enqueue_script('datepicker', get_template_directory_uri() . '/js/datepicker.js', array(), $theme_version->get('Version'), true);
        wp_enqueue_style('datepicker', get_template_directory_uri() . '/css/datepicker.css', array(), $theme_version->get('Version'));
    }

}

/**
 * @Init Sticky Script
 * @return 
 */
if (!function_exists('dexterity_init_sticky_script')) {

    function dexterity_init_sticky_script() {
        $theme_version = wp_get_theme();
        wp_enqueue_script('dexterity_sticky', get_template_directory_uri() . '/js/sticky-em.js', array(), $theme_version->get('Version'), true);
    }

}

/**
 * @Init OWL Script
 * @return 
 */
if (!function_exists('dexterity_init_owl_script')) {

    function dexterity_init_owl_script() {
        $theme_version = wp_get_theme();
        wp_enqueue_style('owl.carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), $theme_version->get('Version'));
        wp_enqueue_script('owl.carousel', get_template_directory_uri() . '/js/owl.carousel.js', array(), $theme_version->get('Version'), true);
    }

}

/**
 * @Init prettyphoto
 * @return 
 */
if (!function_exists('dexterity_prettyphoto_script')) {

    function dexterity_prettyphoto_script() {
        $theme_version = wp_get_theme();
        wp_enqueue_style('dexterity_prettyPhoto_style', get_template_directory_uri() . '/css/prettyPhoto.css', array(), $theme_version->get('Version'));
    }

}

if (!function_exists('dexterity_enque_map_library')) {

    function dexterity_enque_map_library() {
        wp_enqueue_script('jquery-goolge-places', 'http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places', '', '', true);
        wp_enqueue_script('tg_gmap3_script', get_template_directory_uri() . '/js/gmap3.min.js', '', '', true);
    }

}


/**
 * Load Dynamic Styles for Theme
 */
if (!function_exists('dexterity_print_css')) {

    function dexterity_print_css() {
        require_once (get_template_directory() . '/inc/theme-styling/dynamic-styles.php');
    }

    add_action('wp_head', 'dexterity_print_css');
}

/* Custom Fonts Icons */

/* Pagination Code Start */
if (!function_exists('dexterity_prepare_pagination')) {

    function dexterity_prepare_pagination($pages = '', $range = 4) {
        global $paged;

        $showitems = ($range * 2) + 1;

        if (empty($paged)) {
            $current_page = 1;
        }

        $current_page = $paged;

        if ($pages == '') {
            global $wp_query;
            $pages = $wp_query->max_num_pages;
            if (!$pages) {
                $pages = 1;
            }
        } else {
            $pages = ceil($pages / $range);
        }

        if (1 != $pages) {
            echo '<div class="tg-pagination"><ul>';
            if ($current_page > 2 && $current_page > $range + 1 && $showitems < $pages) {
                //echo "<a href='" . get_pagenum_link(1) . "'>&laquo; First</a>";
            }

            if ($current_page > 1) {
                echo "<li class=\"tg-previous\"><a aria-label=\"Previous\" href='" . get_pagenum_link($current_page - 1) . "'><i class=\"fa fa-angle-left\"></i></a></li>";
            }

            for ($i = 1; $i <= $pages; $i++) {
                if (1 != $pages && (!($i >= $current_page + $range + 1 || $i <= $current_page - $range - 1) || $pages <= $showitems )) {
                    echo ($paged == $i) ? "<li><a href='javascript:;'>" . $i . "</a></li>" : "<li><a href='" . get_pagenum_link($i) . "' class=\"inactive\">" . $i . "</a></li>";
                }
            }

            if ($current_page < $pages) {
                echo "<li class=\"tg-next\"><a aria-label=\"Next\" href=\"" . get_pagenum_link($current_page + 1) . "\"><i class=\"fa fa-angle-right\"></i></a></li>";
            }

            if ($current_page < $pages - 1 && $current_page + $range - 1 < $pages && $showitems < $pages) {
                //echo "<a href='" . get_pagenum_link($pages) . "'>Last &raquo;</a>";
            }
            echo "</ul></div>";
        }
    }

}


/**
 * @get post thumbnail
 * @return thumbnail url
 */
if (!function_exists('dexterity_prepare_thumbnail')) {

    function dexterity_prepare_thumbnail($post_id, $width = '300', $height = '300') {
        global $post;

        if (has_post_thumbnail()) {
            get_the_post_thumbnail();
            $thumb_id = get_post_thumbnail_id($post_id);
            $thumb_url = wp_get_attachment_image_src($thumb_id, array($width, $height), true);

            if ($thumb_url[1] == $width and $thumb_url[2] == $height) {
                return $thumb_url[0];
            } else {
                $thumb_url = wp_get_attachment_image_src($thumb_id, "full", true);
                return $thumb_url[0];
            }
        }
    }

}

/**
 * @Hook Favicon
 * @return favicon
 */
if (!function_exists('dexterity_get_favicon')) {

    function dexterity_get_favicon() {

        if (!function_exists('has_site_icon') || !has_site_icon()) {
            if (!function_exists('fw_get_db_settings_option')) {
                return;
            } else {
                $dexterity_favicaon = fw_get_db_settings_option('favicon');
                if (isset($dexterity_favicaon['url'])) {
                    echo '<link rel="shortcut icon" href="' . esc_url($dexterity_favicaon['url']) . '">';
                }
            }
        } else {
            dexterity_wp_favicon();
        }
    }

}

/**
 * @get Categories
 * @return categories
 */
if (!function_exists('dexterity_prepare_categories')) {

    function dexterity_prepare_categories($dexterity_post_cat) {
        global $post, $wpdb;

        if (isset($dexterity_post_cat) && $dexterity_post_cat != '' && $dexterity_post_cat != '0') {
            $dexterity_current_category = $wpdb->get_row($wpdb->prepare("SELECT * from $wpdb->terms WHERE slug = %s", $dexterity_post_cat));
            echo '<span class="tg-cats"><i class="fa fa-folder-open"></i><a href="' . esc_url(site_url('/')) . '?cat=' . $dexterity_current_category->term_id . '">' . $dexterity_current_category->name . '</a></span>';
        } else {
            $before_cat = '<span class="tg-cats"><i class="fa fa-folder-open"></i>';
            $after_cat = '</span>';
            echo get_the_term_list(get_the_id(), 'category', $before_cat, ', ', $after_cat);
        }
    }

}

/**
 * @prepare Custom taxonomies array
 * @return array
 */
if (!function_exists('dexterity_prepare_taxonomies')) {

    function dexterity_prepare_taxonomies($post_type = 'post', $taxonomy = 'category', $hide_empty = 1, $dataType = '') {
        $args = array(
            'type' => $post_type,
            'child_of' => 0,
            'parent' => '',
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => $hide_empty,
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'number' => '',
            'taxonomy' => $taxonomy,
            'pad_counts' => false
        );

        $categories = get_categories($args);

        if ($dataType == 'array') {
            return $categories;
        }

        $custom_cats = array();

        if (isset($categories) && !empty($categories)) {
            foreach ($categories as $key => $value) {
                $custom_cats[$value->term_id] = $value->name;
            }
        }
        return $custom_cats;
    }

}

/**
 * @Favicon Fallback
 * @return favicon
 */
if (!function_exists('dexterity_wp_favicon')) {

    function dexterity_wp_favicon() {

        if (!has_site_icon() && !is_customize_preview()) {
            return;
        }

        $meta_tags = array(
            sprintf('<link rel="icon" href="%s" sizes="32x32" />', esc_url(get_site_icon_url(32))),
            sprintf('<link rel="icon" href="%s" sizes="192x192" />', esc_url(get_site_icon_url(192))),
            sprintf('<link rel="apple-touch-icon-precomposed" href="%s">', esc_url(get_site_icon_url(180))),
            sprintf('<meta name="msapplication-TileImage" content="%s">', esc_url(get_site_icon_url(270))),
        );

        /**
         * Filter the site icon meta tags, so Plugins can add their own.
         *
         * @since 4.3.0
         *
         * @param array $meta_tags Site Icon meta elements.
         */
        $meta_tags = apply_filters('site_icon_meta_tags', $meta_tags);
        $meta_tags = array_filter($meta_tags);

        foreach ($meta_tags as $meta_tag) {
            echo "$meta_tag\n";
        }
    }

}

/**
 * @get next post
 * @return link
 */
if (!function_exists('dexterity_next_post')) {

    function dexterity_next_post($format) {
        $format = str_replace('href=', 'class="next-post" href=', $format);
        return $format;
    }

    add_filter('next_post_link', 'dexterity_next_post');
}

/**
 * @get next post
 * @return link
 */
if (!function_exists('dexterity_previous_post')) {

    function dexterity_previous_post($format) {
        $format = str_replace('href=', 'class="prev-postt" href=', $format);
        return $format;
    }

    add_filter('previous_post_link', 'dexterity_previous_post');
}


/**
 * @get previous post
 * @return link
 */
if (!function_exists('dexterity_prepare_rev_slider')) {

    function dexterity_prepare_rev_slider() {
        $revsliders[] = esc_html__('Select Slider', 'dexterity');
        if (class_exists('RevSlider')) {
            $slider = new RevSlider();
            $arrSliders = $slider->getArrSliders();
            $revsliders = array();
            if ($arrSliders) {
                foreach ($arrSliders as $key => $slider) {
                    $revsliders[$slider->getId()] = $slider->getAlias();
                }
            }
        }

        return $revsliders;
    }

}

/**
 * @get sliders
 * @return {}
 */
if (!function_exists('dexterity_prepare_sliders')) {

    function dexterity_prepare_sliders() {
        global $post, $product;
        $args = array('posts_per_page' => '-1', 'post_type' => 'tg_slider', 'orderby' => 'ID', 'post_status' => 'publish');
        $cust_query = get_posts($args);

        $sliders[0] = esc_html__('Select Slider', 'dexterity');

        if (isset($cust_query) && is_array($cust_query) && !empty($cust_query)) {
            foreach ($cust_query as $key => $slider) {
                $sliders[$slider->ID] = get_the_title($slider->ID);
            }
        }
        return $sliders;
    }

}

/**
 * @get custom Excerpt
 * @return link
 */
if (!function_exists('dexterity_prepare_custom_excerpt')) {

    function dexterity_prepare_custom_excerpt($more = '...') {
        return '....';
    }

    add_filter('excerpt_more', 'dexterity_prepare_custom_excerpt');
}

/**
 * @get Excerpt
 * @return link
 */
if (!function_exists('dexterity_prepare_excerpt')) {

    function dexterity_prepare_excerpt($charlength = '255', $more = 'true', $text = 'Read More') {
        global $post;
        $excerpt = trim(preg_replace('/<a[^>]*>(.*)<\/a>/iU', '', get_the_content()));
        if (strlen($excerpt) > $charlength) {
            if ($charlength > 0) {
                $excerpt = substr($excerpt, 0, $charlength);
            } else {
                $excerpt = $excerpt;
            }
            if ($more == 'true') {
                $link = '<a href="' . esc_url(get_permalink()) . '" class="tg-more">' . esc_attr($text) . '</a>';
            } else {
                $link = '...';
            }
            echo force_balance_tags($excerpt . $link);
        } else {
            echo force_balance_tags($excerpt);
        }
    }

}

/**
 * @Esc Data
 * @return categories
 */
if (!function_exists('dexterity_esc_specialchars')) {

    function dexterity_esc_specialchars($data = '') {
        return $data;
    }

}
/**
 * @Prepare social sharing links
 * @return sizes
 */
if (!function_exists('dexterity_prepare_social_sharing')) {

    function dexterity_prepare_social_sharing($default_icon = 'false', $title = false, $heading = 'Share') {
        dexterity_init_share_script();
        $facebook = esc_html__('Facebook', 'dexterity');
        $twitter = esc_html__('Twitter', 'dexterity');
        $email = esc_html__('E-mail', 'dexterity');
        $tumblr2 = esc_html__('Tumblr', 'dexterity');
        $dribbble2 = esc_html__('Dribbble', 'dexterity');
        $instagram = esc_html__('Instagram', 'dexterity');
        $youtube = esc_html__('Youtube', 'dexterity');


        if (function_exists('fw_get_db_post_option')) {
            $social_facebook = fw_get_db_settings_option('social_facebook');
            $social_twitter = fw_get_db_settings_option('social_twitter');
            $social_email = fw_get_db_settings_option('social_email');
            $social_tumbler = fw_get_db_settings_option('social_tumbler');
            $social_dribble = fw_get_db_settings_option('social_dribble');
            $social_instagram = fw_get_db_settings_option('social_instagram');
            $social_youtube = fw_get_db_settings_option('social_youtube');
        } else {
            $social_facebook = 'enable';
            $social_twitter = 'enable';
            $social_email = 'enable';
            $social_tumbler = '';
            $social_dribble = '';
            $social_instagram = '';
            $social_youtube = '';
        }

        $output = '';
        if ($title == true) {
            $output .='<strong>' . $heading . '</strong>';
        }
        $output .='<ul class="tg-socialicon">';
        if (isset($social_facebook) && $social_facebook == 'enable') {
            $output .='<li class="facebook"><a class="addthis_button_facebook" data-original-title="' . $facebook . '"><i class="fa fa-facebook"></i></a></li>';
        }
        if (isset($social_twitter) && $social_twitter == 'enable') {
            $output .='<li class="twitter"><a class="addthis_button_twitter" data-original-title="' . $twitter . '"><i class="fa fa-twitter"></i></a></li>';
        }
        if (isset($social_email) && $social_email == 'enable') {
            $output .='<li class="google"><a class="addthis_button_google" data-original-title="' . $email . '"><i class="fa fa-google-plus"></i></a></li>';
        }
        if (isset($social_tumbler) && $social_tumbler == 'enable') {
            $output .='<li class="tumblr"><a class="addthis_button_tumblr" data-original-title="' . $tumblr2 . '"><i class="fa fa-tumblr"></i></a></li>';
        }
        if (isset($social_dribble) && $social_dribble == 'enable') {
            $output .='<li class="dribbble" ><a class="addthis_button_dribbble" data-original-title="' . $dribbble2 . '"><i class="fa fa-dribbble"></i></a></li>';
        }
        if (isset($social_instagram) && $social_instagram == 'enable') {
            $output .='<li class="instagram"><a class="addthis_button_instagram" data-original-title="' . $instagram . '"><i class="fa fa-instagram"></i></a></li>';
        }
        if (isset($social_youtube) && $social_youtube == 'enable') {
            $output .='<li class="youtube"><a class="addthis_button_youtube" data-original-title="' . $youtube . '"><i class="fa fa-youtube"></i></a></li>';
        }
        $output .='</ul>';
        echo balanceTags($output, true);
    }

}

/**
 * @Custom post types
 * @return {}
 */
if (!function_exists('dexterity_prepare_custom_posts')) {

    function dexterity_prepare_custom_posts($post_type = 'post') {
        $posts_array = array();
        $args = array('posts_per_page' => "-1", 'post_type' => $post_type, 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);

        $posts_query = get_posts($args);
        foreach ($posts_query as $post_data) :
            $posts_array[$post_data->ID] = $post_data->post_title;
        endforeach;
        return $posts_array;
    }

}

if (!function_exists('dexterity_no_ssl_http_request_args')) {
    add_action('http_request_args', 'dexterity_no_ssl_http_request_args', 10, 2);

    function dexterity_no_ssl_http_request_args($args, $url) {
        $args['sslverify'] = false;
        return $args;
    }

}


/**
 * @User Public Profile
 * @return {}
 */
if (!function_exists('dexterity_edit_user_profile_edit')) {

    function dexterity_edit_user_profile_edit($contactoptions) {
        $display_img_url = '';
        $display = $display_image = 'block';

        $display_img_url = dexterity_get_user_avatar(0, $contactoptions->ID, 'user_avatar_display');

        if (empty($display_img_url)) {
            $display_image = 'elm-display-none';
        }

        //Author BG
        $display_img_bg_url = dexterity_get_user_avatar(0, $contactoptions->ID, 'user_avatar_bg_display');

        if (empty($display_img_bg_url)) {
            $display_bg_image = 'elm-display-none';
        }
        ?>
        <table class="form-table">
            <tbody>
                <tr>
                    <th> <?php esc_html_e('Display Photo', 'dexterity'); ?></th>
                    <td>
                        <input type="hidden" name="user_avatar_display" class="media-image" id="user_avatar_display"  value="<?php echo dexterity_get_user_avatar(0, $contactoptions->ID, 'user_avatar_display'); ?>" />
                        <input type="button" id="upload-user-avatar" class="button button-secondary" value="Uplaod Public Avatar" />
                    </td>
                </tr>
                <tr id="avatar-wrap" class="<?php echo esc_attr($display_image); ?>">
                    <td class="backgroud-image">
                        <a href="javascript:;" class="delete-auhtor-media"><i class="fa fa-times"></i></a>
                        <img class="avatar-src-style" height="100px" src="<?php echo esc_url($display_img_url); ?>" id="avatar-src" />

                    </td>
                </tr>
                <tr>
                    <th> <?php esc_html_e('Author Background Image', 'dexterity'); ?></th>
                    <td>
                        <input type="hidden" name="user_avatar_bg_display" class="media-image" id="user_avatar_bg_display"  value="<?php echo dexterity_get_user_avatar(0, $contactoptions->ID, 'user_avatar_bg_display'); ?>" />
                        <input type="button" id="upload-user-avatar-bg" class="button button-secondary" value="Author Background Image" />
                        <p class="description"><?php esc_html_e('It will be use at blog detail page', 'dexterity'); ?></p>
                    </td>
                </tr>
                <tr id="avatar-wrap-bg" class="<?php echo esc_attr($display_bg_image); ?>">
                    <td class="backgroud-image">
                        <a href="javascript:;" class="delete-auhtor-media"><i class="fa fa-times"></i></a>
                        <img class="avatar-src-style" height="100px" src="<?php echo esc_url($display_img_bg_url); ?>" id="avatar-src-bg" />

                    </td>
                </tr>
            </tbody>
        </table>
        <?php
    }

}

/**
 * @Get User Avatar
 * @return {}
 */
if (!function_exists('dexterity_get_user_avatar')) {

    function dexterity_get_user_avatar($size = 0, $dexterity_user_id = '', $image_type = 'user_avatar_display') {
        if ($dexterity_user_id != '') {
            $dexterity_user_avatars = get_the_author_meta($image_type, $dexterity_user_id);

            if (is_array($dexterity_user_avatars) && isset($dexterity_user_avatars[$size])) {
                return $dexterity_user_avatars[$size];
            } else if (!is_array($dexterity_user_avatars) && $dexterity_user_avatars <> '') {
                return $dexterity_user_avatars;
            }
        }
    }

}

/**
 * @Set Post Views
 * @return {}
 */
if (!function_exists('dexterity_post_views')) {

    function dexterity_post_views($post_id = '') {
        if (!isset($_COOKIE["set_blog_view" . $post_id])) {
            setcookie("set_blog_view" . $post_id, 'post_view_count', time() + 3600);
            $view_key = 'set_blog_view';

            $count = get_post_meta($post_id, $view_key, true);

            if ($count == '') {
                $count = 0;
                delete_post_meta($post_id, $view_key);
                add_post_meta($post_id, $view_key, '0');
            } else {
                $count++;
                update_post_meta($post_id, $view_key, $count);
            }
        }
    }

}

/**
 * @Get Post Views
 * @return {}
 */
if (!function_exists('dexterity_get_post_views')) {

    function dexterity_get_post_views($post_id) {
        $view_key = 'set_blog_view';
        $count = get_post_meta($post_id, $view_key, true);
        if ($count == '') {
            delete_post_meta($post_id, $view_key);
            add_post_meta($post_id, $view_key, '0');
            return "0 ";
        }
        return number_format($count);
    }

}

/**
 * @Get Post Views
 * @return {}
 */
if (!function_exists('dexterity_get_users')) {

    function dexterity_get_users() {
        $users[''] = 'Select Organizer';
        $site_users = get_users('orderby=nicename');
        foreach ($site_users as $user) {
            $users[$user->ID] = $user->display_name;
        }
        return $users;
    }

}

/**
 * @User Public Profile Save
 * @return {}
 */
if (!function_exists('dexterity_personal_options_save')) {

    function dexterity_personal_options_save($user_id) {
        $user_avatar_display = (isset($_POST['user_avatar_display']) && $_POST['user_avatar_display'] <> '') ? $_POST['user_avatar_display'] : '';
        update_user_meta($user_id, 'user_avatar_display', $user_avatar_display);

        //BG
        $user_avatar_bg_display = (isset($_POST['user_avatar_bg_display']) && $_POST['user_avatar_bg_display'] <> '') ? $_POST['user_avatar_bg_display'] : '';
        update_user_meta($user_id, 'user_avatar_bg_display', $user_avatar_bg_display);
    }

}

/**
 * @User Public Profile Save
 * @return {}
 */
if (!function_exists('dexterity_get_post_name')) {

    function dexterity_get_post_name($returnClass = 'false') {
        global $post;
        $post_name = '';
        if (isset($post)) {
            $post_name = $post->post_name;
        } else {
            $post_name = '';
        }

        return $post_name;
    }

}

/**
 * @User Public Profile Save
 * @return {}
 */
if (!function_exists('dexterity_comingsoon_background')) {

    function dexterity_comingsoon_background() {
        $background_comingsoon = '';
        if (function_exists('fw_get_db_post_option')) {
            $background = fw_get_db_settings_option('background');
            if (isset($background['url']) && !empty($background['url'])) {
                //Do Nothing
            } else {
                $background['url'] = get_template_directory_uri() . '/images/comming-soon-bg.jpg';
            }
        } else {
            $background['url'] = get_template_directory_uri() . '/images/comming-soon-bg.jpg';
        }

        if (isset($background['url']) && !empty($background['url'])) {
            $background_comingsoon = $background['url'];
            ;
        }

        return $background_comingsoon;
    }

}

/**
 * @Language Handler
 * @return {sub menu class}
 */
add_action('fw_ext_translation_change_render_language_switcher', function ( $html, $frontend_urls ) {
    $html = '';
    //fw_print($frontend_urls);
    foreach ($frontend_urls as $lang_code => $url) {
        $html .= '<li><a href="' . esc_attr($url) . '"><img src="' . fw_ext_translation_get_flag($lang_code) . '" alt="' . $lang_code . '"><span>' . $lang_code . '</span></a></li>';
    }
    return $html;
}, 10, 2);

/**
 * @Naigation Filter
 * @return {sub menu class}
 */
if (!function_exists('dexterity_submenu_class')) {

    function dexterity_submenu_class($menu) {
        $menu = preg_replace('/ class="sub-menu"/', ' class=""', $menu);
        return $menu;
    }

    add_filter('wp_nav_menu', 'dexterity_submenu_class');
}

/**
 * Get Featured Products
 */
if (!function_exists('dexterity_prepare_featured_products')) {

    function dexterity_prepare_featured_products() {
        $featured_posts = array();
        if (class_exists('woocommerce')) {
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'ignore_sticky_posts' => 1,
                'posts_per_page' => -1,
                'meta_query' => array(
                    // get only products marked as featured
                    array(
                        'key' => '_featured',
                        'value' => 'yes'
                    )
                )
            );
            $fetaured_query = get_posts($args);
            if (isset($fetaured_query) && !empty($fetaured_query)) {
                foreach ($fetaured_query as $featured_products) {
                    $featured_posts[$featured_products->ID] = $featured_products->post_title;
                }
            }
        }
        return $featured_posts;
    }

}

/**
 * @Custom Title Linking
 * @return {}
 */
if (!function_exists('dexterity_get_registered_sidebars')) {
    function dexterity_get_registered_sidebars() {
		global $wp_registered_sidebars;
		$sidebars	= array();
		foreach( $wp_registered_sidebars as $key => $sidebar ){
			$sidebars[$key]	= $sidebar['name'];
		}
		return $sidebars;
	}
}

/**
 * @Add Images Sizes
 * @return sizes
 */
add_image_size('dexterity_blog_detail', 1170, 400, true);
add_image_size('dexterity_carousel_services', 480, 350, true);
add_image_size('dexterity_blog_list', 370, 300, true);
add_image_size('dexterity_blog_grid', 270, 300, true);
add_image_size('dexterity_slider_thumbnail', 300, 300, true);

