<?php

/**
 * File Type: VehicleType
 */
if (!class_exists('TG_Services')) {

    class TG_Services {

        public function __construct() {
            global $pagenow;
            add_action('init', array(&$this, 'init_services'));
        }

        /**
         * @Init Post Type
         * @return {post}
         */
        public function init_services() {
            $this->prepare_post_type();
        }

        /**
         * @Prepare Post Type
         * @return {}
         */
        public function prepare_post_type() {
            $labels = array(
                'name' => esc_html__('Services', 'themographics_core'),
                'all_items' => esc_html__('Services', 'themographics_core'),
                'singular_name' => esc_html__('Service', 'themographics_core'),
                'add_new' => esc_html__('Add Service', 'themographics_core'),
                'add_new_item' => esc_html__('Add New Service', 'themographics_core'),
                'edit' => esc_html__('Edit', 'themographics_core'),
                'edit_item' => esc_html__('Edit Service', 'themographics_core'),
                'new_item' => esc_html__('New Service', 'themographics_core'),
                'view' => esc_html__('View Service', 'themographics_core'),
                'view_item' => esc_html__('View Service', 'themographics_core'),
                'search_items' => esc_html__('Search Service', 'themographics_core'),
                'not_found' => esc_html__('No Service found', 'themographics_core'),
                'not_found_in_trash' => esc_html__('No Service found in trash', 'themographics_core'),
                'parent' => esc_html__('Parent Service', 'themographics_core'),
            );
            $args = array(
                'labels' => $labels,
                'description' => esc_html__('This is where you can add new AppointmentCategory', 'themographics_core'),
                'public' => true,
                'supports' => array('title'),
                'show_ui' => true,
                'capability_type' => 'post',
                'map_meta_cap' => true,
                'publicly_queryable' => true,
                'exclude_from_search' => false,
                'hierarchical' => false,
                'menu_position' => 10,
                'rewrite' => array('slug' => 'services', 'with_front' => true),
                'query_var' => false,
                'has_archive' => 'false',
            );
            register_post_type('tg_services', $args);
        }

        /**
         * @Prepare Project Project
         * @return {}
         */
    }

    new TG_Services();
}