<?php
/**
 * The template for displaying all single posts.
 *
 * @package Dexterity
 */
get_header();
$uni_flag = fw_unique_increment();
?>
<div class="container">
	<div class="row">
		<div class="tg-portfoliocontent tg-haslayout">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<?php
				while (have_posts()) : the_post();
					if (function_exists('dexterity_init_owl_script')) {
						dexterity_init_owl_script();
					}
					$user_ID = get_the_author_meta('ID');
					$udata = get_userdata($user_ID);
					$registered = $udata->user_registered;
					$user_avatar_display = get_the_author_meta('user_avatar_display', $user_ID);
					$height = 450;
					$width = 1170;
					$thumbnail = dexterity_prepare_thumbnail($post->ID, $width, $height);
					$image_src = dexterity_prepare_thumbnail($post->ID, 'full');
					$user_id = get_the_author_meta('ID');
					$user_url = get_author_posts_url($user_id);
					$flag = rand(99, 99999);
					if (!function_exists('fw_get_db_post_option')) {
						$blog_settings = '';
						$enable_auhtor_info = '';
						$slider_gallery = '';
					} else {
						$blog_settings = fw_get_db_post_option($post->ID, 'post_settings', true);
						$enable_auhtor_info = fw_get_db_post_option($post->ID, 'enable_auhtor_info', true);
						$slider_gallery = fw_get_db_post_option($post->ID, 'gallery', true);
					}
					if (isset($blog_settings) && $blog_settings == 'gallery') {
						$blogClass = 'gallery-post';
					} else {
						$blogClass = '';
					}
					$blog_post_gallery = array();
					$post_video = '';
					if (isset($blog_settings['gallery']['blog_post_gallery']) && !empty($blog_settings['gallery']['blog_post_gallery'])) {
						$blog_post_gallery = $blog_settings['gallery']['blog_post_gallery'];
					}
					?>
					<div id="tg-content" class="tg-content tg-post-detail tg-overflowhidden">
						<article class="tg-singlepost tg-haslayout">
							<div class="row">
								<?php if(isset($slider_gallery ) && !empty($slider_gallery )){?>
								<div class="col-sm-10 tg-verticalbottom">
									<a class="tg-btn"><?php esc_html_e('by: ', 'themographics_core'); ?> <?php echo ucfirst(get_the_author_meta('nickname')); ?></a>
									<div id="tg-blogdetail-slider" class="tg-blogdetail-slider tg-haslayout">
										<div class="swiper-container gallery-top">
											<div class="swiper-wrapper">
												<?php
												foreach ($slider_gallery as $gallery) {
													$attachment_id = $gallery['attachment_id'];
													$image_data = wp_get_attachment_image_src($attachment_id, 'dexterity_blog_listing');
													if (isset($image_data) && !empty($image_data) && $image_data[0] != '') {
														?>
														<div class="swiper-slide">
															<img src="<?php echo esc_url($image_data[0]); ?>" alt="<?php echo get_bloginfo('name'); ?>">
														</div>
														<?php
													}
												}
												?>
											</div>
										</div>
										<div class="swiper-button-next swiper-button-white"></div>
										<div class="swiper-button-prev swiper-button-white"></div>
									</div>
								</div>
								<?php } ?>
								<?php if(isset($slider_gallery ) && !empty($slider_gallery )){?>
								<div class="col-sm-2 tg-verticalbottom">
									<div id="tg-blogdetail-thumb-slider" class="tg-blogdetail-thumb-slider">
										<div class="swiper-container gallery-thumbs">
											<div class="swiper-wrapper">
												<?php
												foreach ($slider_gallery as $gallery) {
													$attachment_id = $gallery['attachment_id'];
													$image_data = wp_get_attachment_image_src($attachment_id, array(300,300));
													if (isset($image_data) && !empty($image_data) && $image_data[0] != '') {
														?>
														<div class="swiper-slide">
															<figure>
																<img src="<?php echo esc_url($image_data[0]); ?>" alt="<?php echo get_bloginfo('name'); ?>">
																<div class="tg-img-hover">
																	<a><i class="fa fa-plus"></i></a>
																</div>
															</figure>
														</div>
														<?php
													}
												}
												?>
											</div>
										</div>
									</div>
								</div>
								<?php } ?>
								<div class="tg-portfoliocontent tg-haslayout">
									<div class="col-sm-8">
										<div class="tg-heading-border">
											<h3><?php the_title(); ?></h3>
										</div>
										<div class="tg-description">
											<?php the_content(); ?>
										</div>
									</div>
									<?php
									$project_info = fw_get_db_post_option($post->ID, 'extras', true);
									if (isset($project_info) && !empty($project_info)) {?>
										<div class="col-sm-4">
											<div class="tg-projectinfo tg-haslayout">
												<div class="tg-heading-border">
													<h3><?php esc_html_e('Project info', 'themographics_core') ?></h3>
												</div>
												<ul class="tg-haslayout">
												<?php
													foreach ($project_info as $project_extra) {
														?>                           
														<li>
															<a href="<?php echo esc_url(get_the_permalink()); ?>">
																<em><?php echo esc_attr($project_extra['label']); ?></em>
																<i><?php echo esc_attr($project_extra['value']); ?></i>
															</a>
														</li>
													<?php } ?>
													<li>
														<em><?php esc_html_e('follow', 'themographics_core') ?></em>
														<ul class="tg-socialicons">
															<?php
															$social_icon = fw_get_db_post_option($post->ID, 'social_icons', true);
														   
															foreach ($social_icon as $social) {
																if (isset($social['social_url']) && !empty($social['social_url'])) {
																	$url = $social['social_url'];
																}
																?>
																<li>
																	<a href="<?php echo esc_url($url); ?>">
																		<i class="<?php echo esc_attr($social['social_icons_list']); ?>"></i>
																	</a>
																</li>
															<?php } ?>
														</ul>
													</li>
												</ul>
											</div>
										</div>
									<?php } ?>
								</div>
							</div>
						</article>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
	</div>
</div>
<div class="tg-alsolike tg-haslayout">
	<div class="container">
		<div class="row">
			<?php
			$args = array('posts_per_page' => 3, 
				'post_type' => 'tg_projects', 
				'paged' => '', 
				'order' => 'DESC', 
				'orderby' => 'ID', 
				'post_status' => 'publish', 
				'ignore_sticky_posts' => 1,
				'post__not_in' => array($post->ID),
			);
			$query = new WP_Query($args);
			while ($query->have_posts()) : $query->the_post();
				global $post;
				$width = '150';
				$height = '150';
				$thumbnail = dexterity_prepare_thumbnail($post->ID, $width, $height);
				if (isset($thumbnail) && $thumbnail) {
					$thumbnail = $thumbnail;
				} else {
					$thumbnail = get_template_directory_uri() . '/images/grid-placeholder.png';
				}
				?>
				<div class="col-sm-4">
					<div class="tg-project">
						<figure>
							<img src="<?php echo esc_url($thumbnail); ?>" alt="<?php the_title(); ?>">
							<figcaption class="tg-img-hover">
								<div class="tg-box tg-displayblock">
									<div class="tg-heading-border">
										<time datetime="2015-04-08 08:15"><?php echo date_i18n('F d , Y', strtotime(get_the_date())); ?></time>
										<h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
									</div>
									<ul class="tg-socialicons tg-large">
										<li>
											<a href="<?php echo esc_url($thumbnail); ?>" data-rel="prettyPhoto[project]"><i class="fa fa-search"></i></a>
										</li>
										<li>
											<a href="<?php echo esc_url($thumbnail); ?>"><i class="fa fa-link"></i></a>
										</li>
									</ul>
								</div>
							</figcaption>
						</figure>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>