<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'heading' => array(
        'label' => esc_html__('Heading', 'dexterity'),
        'desc' => esc_html__('Enter The Blog Heading Here.', 'dexterity'),
        'type' => 'text'
    ),
    'blog_description' => array(
        'label' => esc_html__('Short Description', 'dexterity'),
        'desc' => esc_html__('Enter The Blog Description Here.', 'dexterity'),
        'type' => 'textarea'
    ),
    'blog_view' => array(
        'type' => 'select',
        'value' => 'grid',
        'label' => esc_html__('Select View', 'dexterity'),
        'choices' => array(
            'grid' => esc_html__('Grid', 'dexterity'),
            'list' => esc_html__('List', 'dexterity'),
            
        ),
    ),
    'posts_category' => array(
        'type' => 'multi-select',
        'label' => esc_html__('Select Posts Categories', 'dexterity'),
        'population' => 'taxonomy',
        'source' => 'category',
        'desc' => esc_html__('Show posts by category selection.', 'dexterity'),
    ),
    'show_posts' => array(
        'type' => 'slider',
        'value' => 9,
        'properties' => array(
            'min' => 0,
            'max' => 20,
            'sep' => 1,
        ),
        'label' => esc_html__('Show No of Posts', 'dexterity'),
    ),
    'show_pagination' => array(
        'type' => 'select',
        'value' => 'yes',
        'label' => esc_html__('Show Pagination', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
        'choices' => array(
            'yes' => esc_html__('Yes', 'dexterity'),
            'no' => esc_html__('No', 'dexterity'),
        ),
        'no-validate' => false,
    ),
    'show_description' => array(
        'type' => 'switch',
        'value' => 'show',
        'label' => esc_html__('Description', 'dexterity'),
        'desc' => esc_html__('', 'dexterity'),
        'left-choice' => array(
            'value' => 'show',
            'label' => esc_html__('Show Description', 'dexterity'),
        ),
        'right-choice' => array(
            'value' => 'hide',
            'label' => esc_html__('Hide Description', 'dexterity'),
        ),
    ),
    'excerpt_length' => array(
        'type' => 'slider',
        'value' => 123,
        'properties' => array(
            'min' => 0,
            'max' => 1000,
            'sep' => 1,
        ),
        'label' => esc_html__('Excerpt length', 'dexterity'),
    ),
);
