<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
?>
<div class="sc-grid">
    <div class="col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
        <div class="tg-section-head">
            <?php if (isset($atts['heading']) && !empty($atts['heading'])) { ?>
                <div class="tg-theme-heading">
                    <h2><?php echo esc_attr($atts['heading']); ?></h2>
                </div>
            <?php } ?>
            <?php if (isset($atts['blog_description']) && !empty($atts['blog_description'])) { ?>
                <div class="tg-description">
                    <p><?php echo esc_attr($atts['blog_description']); ?></p>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="tg-blogposts">
        <div class="row">
            <?php
            global $paged;
            if (empty($paged))
                $paged = 1;

            $blog_view = $atts['blog_view'];
            // Count Total Pssts

            $tax_query['cat'] = '';
            $cat_sepration = $atts['posts_category'];

            if (isset($cat_sepration) && !empty($cat_sepration)) {
                $tax_query['cat'] = implode(',', $cat_sepration);
            }

            $show_posts = $atts['show_posts'] ? $atts['show_posts'] : '-1';
            $args = array('posts_per_page' => "-1", 'post_type' => 'post', 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);

            if (isset($cat_sepration) && !empty($cat_sepration)) {
                $args = array_merge($args, $tax_query);
            }

            $query = new WP_Query($args);
            $count_post = $query->post_count;

            //Main Query	
            $args = array('posts_per_page' => $show_posts, 'post_type' => 'post', 'paged' => $paged, 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);

            if (isset($cat_sepration) && !empty($cat_sepration)) {
                $args = array_merge($args, $tax_query);
            }

            $query = new WP_Query($args);
            while ($query->have_posts()) : $query->the_post();
                global $post;
                $width = '270';
                $height = '300';
                $thumbnail = dexterity_prepare_thumbnail($post->ID, $width, $height);

                if (isset($thumbnail) && $thumbnail) {
                    $thumbnail = $thumbnail;
                } else {
                    $thumbnail = get_template_directory_uri() . '/images/grid-placeholder.png';
                }
                ?>
                <div class="col-md-6 col-sm-12 col-xs-12">
                    <article class="tg-post no-gutters">
                        <div class="col-sm-6 tg-verticalmiddle">
                            <figure>
                                <img src="<?php echo esc_url($thumbnail); ?>" alt="<?php the_title(); ?>">
                                <figcaption class="tg-img-hover">
                                    <div class="tg-box tg-displayblock">
                                        <ul class="tg-socialicons tg-large">
                                            <li><a href="<?php echo esc_url(get_the_permalink()); ?>"><i class="fa fa-link"></i></a></li>
                                        </ul>
                                    </div>
                                </figcaption>
                            </figure>
                        </div>
                        <div class="col-sm-6 tg-verticalmiddle">
                            <div class="tg-post-content">
                                <a class="tg-btn"><?php esc_html_e('by: ', 'dexterity'); ?> <?php echo ucfirst(get_the_author_meta('nickname')); ?></a>
                                <div class="tg-heading-border">
                                    <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                                </div>
                                <?php if (isset($atts['show_description']) && $atts['show_description'] === 'show') { ?>
                                    <div class="tg-description">
                                        <?php dexterity_prepare_excerpt($atts['excerpt_length'], 'false', ''); ?>
                                    </div>
                                <?php } ?>
                                <ul class="tg-postmeta">
                                    <li><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo date_i18n('F d , Y', strtotime(get_the_date('Y-m-d',$post->ID))); ?></a></li>
                                    <li> <?php echo get_the_term_list($post->ID , 'category'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </article>
                </div>
                <?php
            endwhile;
            wp_reset_postdata();
            ?>
            <div class="col-xs-12">
				<?php if (isset($atts['show_pagination']) && $atts['show_pagination'] == 'yes') : ?>
                    <?php dexterity_prepare_pagination($count_post, $atts['show_posts']); ?>
                <?php endif; ?>
			</div>
        </div>
    </div>
</div>
