<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
?>
<div class="sc-list">
    <div id="tg-content" class="tg-content tg-bloglist tg-haslayout">
        <?php
        global $paged;
        if (empty($paged))
            $paged = 1;

        $blog_view = $atts['blog_view'];
        // Count Total Pssts

        $tax_query['cat'] = '';
        $cat_sepration = $atts['posts_category'];

        if (isset($cat_sepration) && !empty($cat_sepration)) {
            $tax_query['cat'] = implode(',', $cat_sepration);
        }
        $show_posts = $atts['show_posts'] ? $atts['show_posts'] : '-1';
        $args = array('posts_per_page' => "-1", 'post_type' => 'post', 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);

        if (isset($cat_sepration) && !empty($cat_sepration)) {
            $args = array_merge($args, $tax_query);
        }

        $query = new WP_Query($args);
        $count_post = $query->post_count;

        //Main Query	
        $args = array('posts_per_page' => $show_posts, 'post_type' => 'post', 'paged' => $paged, 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);

        if (isset($cat_sepration) && !empty($cat_sepration)) {
            $args = array_merge($args, $tax_query);
        }

        $query = new WP_Query($args);
        while ($query->have_posts()) : $query->the_post();
            global $post;
            $width = '370';
            $height = '300';
            $thumbnail = dexterity_prepare_thumbnail($post->ID, $width, $height);
			$contentLength	= 'col-lg-12 col-md-12 col-sm-12 tg-verticalmiddle';
			$no_media	= empty(  $thumbnail ) ? 'no-image-list' : 'with-thumb';
            ?>
            <article class="tg-post no-gutters <?php echo sanitize_html_class( $no_media );?>">
				<?php if (isset($thumbnail) && !empty($thumbnail)) { 
					$contentLength	= 'col-lg-8 col-md-7 col-sm-12 tg-verticalmiddle';
					?>
                    <div class="col-lg-4 col-md-5 col-sm-12 tg-verticalmiddle">
                        <figure>
                            <img alt="<?php echo sanitize_title( get_the_title() ); ?>" src="<?php echo esc_url($thumbnail); ?>">
                            <figcaption class="tg-img-hover">
                                <div class="tg-box tg-displayblock">
                                    <ul class="tg-socialicons tg-large">
                                        <li><a href="<?php echo esc_url(get_the_permalink()); ?>"><i class="fa fa-link"></i></a></li>
                                    </ul>
                                </div>
                            </figcaption>
                        </figure>
                    </div>
                <?php } ?>
                <div class="<?php echo esc_attr( $contentLength );?>">
                    <div class="tg-post-content">
                        <a class="tg-btn"><?php esc_html_e('by: ', 'dexterity'); ?><?php echo ucfirst(get_the_author_meta('nickname')); ?></a>
                        <div class="tg-heading-border">
                            <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
                        </div>
                        <?php if (isset($atts['show_description']) && $atts['show_description'] === 'show') { ?>
                            <div class="tg-description">
                                <?php dexterity_prepare_excerpt($atts['excerpt_length'], 'false', ''); ?>
                            </div>
                        <?php } ?>
                        <ul class="tg-postmeta">
                            <li><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo date_i18n('F d , Y', strtotime(get_the_date('Y-m-d',$post->ID))); ?></a></li>
                            <?php echo get_the_term_list ( $post->ID, 'category', '<li> ' , ', ', '</li>' ); ?>
                        </ul>
                    </div>
                    <?php
					  if ( is_sticky() && !is_singular() ) :
					  echo '<div class="sticky-post-wrap">
								  <div class="sticky-txt">
								   <em class="tg-featuretext">'.esc_html__('Featured','dexterity').'</em>
								   <i class="fa fa-bolt"></i>
								  </div>
							 </div>';
					  endif;
					?>
                </div>
            </article>
            <?php
        endwhile;
        wp_reset_postdata();
        ?>

    </div>
</div>

    <?php if (isset($atts['show_pagination']) && $atts['show_pagination'] == 'yes') : ?>
        <?php dexterity_prepare_pagination($count_post, $atts['show_posts']); ?>
    <?php endif; ?>