<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
?>
<div class="sc-contactinfo">
    <div class="tg-contact-detail">
        <?php if (isset($atts['title']) && !empty($atts['title'])) { ?>
            <div class="tg-heading-border">
                <h3><?php echo esc_attr($atts['title']); ?></h3>
            </div>
        <?php } ?>
        <?php if (isset($atts['short_descripion']) && !empty($atts['short_descripion'])) { ?>
            <div class="tg-description">
                <p><?php echo esc_attr($atts['short_descripion']); ?></p>
            </div>
        <?php } ?>
        <ul class="tg-info">
            <?php if (isset($atts['contact_popup']) && !empty($atts['contact_popup'])) { ?>
                <?php foreach ($atts['contact_popup'] as $contact) { ?>        
                    <li>
                        <span><?php echo esc_attr($contact['contact_title']); ?></span>
                        <?php echo force_balance_tags($contact['contact_descripion']); ?>
                    </li>
                <?php } ?>
            <?php } ?>
            <li>
                <span><?php esc_html_e('Follow :', 'dexterity') ?></span>
                <?php if (isset($atts['social_popup']) && !empty($atts['social_popup'])) { ?>
                    <ul class="tg-socialicons">
                        <?php
                        foreach ($atts['social_popup'] as $social) {
                            if (isset($social['icon_link']) && !empty($social['icon_link'])) {
                                $link = $social['icon_link'];
                            }
                            if (isset($social['social_icons']) && !empty($social['social_icons'])) {
                                $icon = $social['social_icons'];
                            }
                            ?>   
                            <li>
                                <a href="<?php echo esc_url($link); ?>"><i class="<?php echo esc_attr($icon); ?>"></i></a>
                            </li>
                        <?php } ?>

                    </ul> 
                </li>
            </ul>
        <?php } ?>
    </div>
</div>