<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
$categories = $atts['categories'];
$show_posts = $atts['show_posts'];
$show_filterable = $atts['show_filterable'];
$project_view = $atts['project_view'];

?>
<div class="sc-project">
    <div class="col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
        <div class="tg-section-head">
            <?php if (isset($atts['heading']) && !empty($atts['heading'])) { ?>
                <div class="tg-theme-heading">
                    <h2><?php echo esc_attr($atts['heading']); ?></h2>
                </div>
            <?php } ?>
            <?php if (isset($atts['project_description']) && !empty($atts['project_description'])) { ?>
                <div class="tg-description">
                    <p><?php echo esc_attr($atts['project_description']); ?></p>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="<?php echo esc_attr( $project_view );?> tg-haslayout">
    <?php
		$cat_sepration = array();
		$filterable = array();
	
		if (isset($categories) && !empty($categories)) {
			$cat_sepration = $categories;
		}
		if (isset($cat_sepration) && !empty($cat_sepration)) {
			$slugs = array();
			$loop = array();
			foreach ($cat_sepration as $key => $value) {
				$term = get_term($value, 'project-category');
				$slugs[] = $term->slug;
				$loop[$term->slug] = $term->name;
			}
			$filterable = $slugs;
			$filterable_loop = $loop;
			$tax_query['tax_query'] = array('relation' => 'AND', array(
					'taxonomy' => 'project-category',
					'terms' => $filterable,
					'field' => 'slug',
			));
		}
	
		$show_posts = isset($show_posts) && !empty($show_posts) ? $show_posts : '8';
		if (empty($paged))
			$paged = 1;
		$show_posts = $show_posts ? $show_posts : '-1';
		$query_args = array('posts_per_page' => "-1", 'post_type' => 'tg_projects', 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);
	
		if (isset($cat_sepration) && !empty($cat_sepration)) {
			$query_args = array_merge($query_args, $tax_query);
		}
		//Pretty Photo
		if (function_exists('dexterity_prettyphoto_script')) {
			dexterity_prettyphoto_script();
		}
		$query = new WP_Query($query_args);
		$count_post = $query->post_count;
		//Main Query	
		$query_args = array('posts_per_page' => $show_posts, 'post_type' => 'tg_projects', 'order' => 'DESC', 'orderby' => 'ID', 'post_status' => 'publish', 'ignore_sticky_posts' => 1);
	
		if (isset($cat_sepration) && !empty($cat_sepration)) {
			$query_args = array_merge($query_args, $tax_query);
		}
		?>
		<?php if (isset($show_filterable) && $show_filterable === 'yes' && !empty($filterable_loop)) { ?>
			<div class="tg-portfolio-head tg-haslayout">
				<ul id="tg-filterbale-nav" class="tg-filterbale-nav option-set">
					<li><a class="active" data-filter="*" href="javascript:void(0);"><?php esc_html_e('All', 'dexterity'); ?></a></li>
					<?php foreach ($filterable_loop as $key => $value) { ?>
						<li><a data-filter=".<?php echo esc_attr($key); ?>" href="javascript:void(0);"><?php echo esc_attr($value); ?></a></li>
					<?php } ?>
	
				</ul>
			</div>
		<?php } ?>
		<div class="clearfix"></div>
		<div class="row">
			<div id="filter-masonry" class="tg-portfolio-content tg-haslayout">
				<?php
				global $post;
				while ($query->have_posts()) : $query->the_post();
					$width = 0;
					$height = 0;
					$thumbnail = dexterity_prepare_thumbnail($post->ID, $width, $height);
					$categories_array = array();
					$categories = get_the_terms($post->ID, 'project-category');
					if (is_array($categories)) {
						foreach ($categories as $category) {
							$categories_array[$category->slug] = $category->slug;
						}
					}
					?>
					<div class="masonry-grid <?php echo implode(' ', $categories_array); ?>">
						<div class="tg-project">
							<figure>
								<img src="<?php echo esc_url($thumbnail); ?>" alt="<?php the_title(); ?>">
								<figcaption class="tg-img-hover">
									<div class="tg-box tg-displayblock">
										<div class="tg-heading-border">
											<time datetime="2015-04-08 08:15"><?php echo date_i18n('F d , Y', strtotime(get_the_date('Y-m-d',$post->ID))); ?></time>
											<h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>
										</div>
										<ul class="tg-socialicons tg-large">
											<li>
												<a href="<?php echo esc_url($thumbnail); ?>" data-rel="prettyPhoto[project]"><i class="fa fa-search"></i></a>
											</li>
											<li>
												<a href="<?php echo esc_url(get_the_permalink()); ?>"><i class="fa fa-link"></i></a>
											</li>
										</ul>
									</div>
								</figcaption>
							</figure>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
	</div>
</div>
