<?php

if (!defined('FW')) {
    die('Forbidden');
}

$options = array(
    'general_settings' => array(
        'type' => 'tab',
        'title' => esc_html__('Genral Settings', 'dexterity'),
        'options' => array(
            'section_heading' => array(
                'label' => esc_html__('Section Heading', 'dexterity'),
                'desc' => esc_html__('Enter Your Section Heading Here', 'dexterity'),
                'type' => 'text',
            ),
			'is_fullwidth' => array(
                'type' => 'select',
                'value' => 'default',
                'attr' => array(),
                'label' => esc_html__('Section Settings', 'dexterity'),
                'desc' => esc_html__('Select Section Settings', 'dexterity'),
                'help' => esc_html__('', 'dexterity'),
                'choices' => array(
                    'default' => esc_html__('Default', 'dexterity'),
					'stretch_section' => esc_html__('Stretch Section', 'dexterity'),
                    'stretch_section_contents' => esc_html__('Stretch Section With Contents', 'dexterity'),
                    'stretch_section_contents_corner' => esc_html__('Stretch Section With Contents(No Padding)', 'dexterity'),
                    
                ),
            ),
            'background_color' => array(
                'label' => esc_html__('Background Color', 'dexterity'),
                'desc' => esc_html__('Please select the background color', 'dexterity'),
                'type' => 'color-picker',
            ),
            'background_image' => array(
                'label' => esc_html__('Background Image', 'dexterity'),
                'desc' => esc_html__('Please select the background image', 'dexterity'),
                'type' => 'background-image',
                'choices' => array(//	in future may will set predefined images
                )
            ),
            'background_repeat' => array(
                'type' => 'select',
                'value' => 'no-repeat',
                'attr' => array(),
                'label' => esc_html__('Background Repeat', 'dexterity'),
                'desc' => esc_html__('Repeat Background', 'dexterity'),
                'help' => esc_html__('', 'dexterity'),
                'choices' => array(
                    'no-repeat' => esc_html__('No Repeat', 'dexterity'),
                    'repeat' => esc_html__('Repeat', 'dexterity'),
                    'repeat-x' => esc_html__('Repeat X', 'dexterity'),
                    'repeat-y' => esc_html__('Repeat Y', 'dexterity'),
                ),
            ),
            'positioning_x' => array(
                'type' => 'slider',
                'value' => 0,
                'properties' => array(
                    'min' => -100,
                    'max' => 100,
                    'sep' => 1,
                ),
                'desc' => esc_html__('Background position Horizontally', 'dexterity'),
                'label' => esc_html__('Position X, IN ( % )', 'dexterity'),
            ),
            'positioning_y' => array(
                'type' => 'slider',
                'value' => 100,
                'properties' => array(
                    'min' => -100,
                    'max' => 100,
                    'sep' => 1,
                ),
                'desc' => esc_html__('Background position Vertically', 'dexterity'),
                'label' => esc_html__('Position Y, IN ( % )', 'dexterity'),
            ),
            'video' => array(
                'label' => esc_html__('Background Video', 'dexterity'),
                'desc' => esc_html__('Insert Video URL to embed this video', 'dexterity'),
                'type' => 'text',
            ),
            'custom_id' => array(
                'label' => esc_html__('Custom ID', 'dexterity'),
                'desc' => esc_html__('Add Custom ID', 'dexterity'),
                'type' => 'text',
            ),
            'custom_classes' => array(
                'label' => esc_html__('Custom Classes', 'dexterity'),
                'desc' => esc_html__('Add Custom Classes', 'dexterity'),
                'type' => 'text',
            )
        )
    ),
    'margin_settings' => array(
        'type' => 'tab',
        'title' => esc_html__('Margin', 'dexterity'),
        'options' => array(
            'margin_top' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Margin Top', 'dexterity'),
				'desc' => esc_html__('add margin, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
			'margin_bottom' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Margin Bottom', 'dexterity'),
				'desc' => esc_html__('add margin, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
			'margin_left' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Margin Left', 'dexterity'),
				'desc' => esc_html__('add margin, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
			'margin_right' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Margin Right', 'dexterity'),
				'desc' => esc_html__('add margin, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
        )
    ),
    'padding_settings' => array(
        'type' => 'tab',
        'title' => esc_html__('Padding', 'dexterity'),
        'options' => array(
            'padding_top' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Padding Top', 'dexterity'),
				'desc' => esc_html__('add padding, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
			'padding_bottom' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Padding Bottom', 'dexterity'),
				'desc' => esc_html__('add padding, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
			'padding_left' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Padding Left', 'dexterity'),
				'desc' => esc_html__('add padding, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
			'padding_right' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Padding Right', 'dexterity'),
				'desc' => esc_html__('add padding, Leave it empty to hide, Note: add only integer value as : 10', 'dexterity'),
			),
        )
    ),
    'parallax_settings' => array(
        'type' => 'tab',
        'title' => esc_html__('Parallax', 'dexterity'),
        'options' => array(
            'parallax' => array(
                'label' => esc_html__('Parallax', 'dexterity'),
                'desc' => esc_html__('Use background image as parallax.', 'dexterity'),
                'type' => 'switch',
                'value' => 'off',
                'left-choice' => array(
                    'value' => 'on',
                    'label' => esc_html__('ON', 'dexterity'),
                ),
                'right-choice' => array(
                    'value' => 'off',
                    'label' => esc_html__('OFF', 'dexterity'),
                ),
            ),
            'parallax_bleed' => array(
                'type' => 'slider',
                'value' => 0,
                'properties' => array(
                    'min' => 0,
                    'max' => 500,
                    'sep' => 1,
                ),
                'label' => esc_html__('Parallax Data Bleed', 'dexterity'),
            ),
            'parallax_speed' => array(
                'type' => 'select',
                'value' => 'no-repeat',
                'attr' => array(),
                'label' => esc_html__('Parallax Speed', 'dexterity'),
                'desc' => esc_html__('Choose Your Parallax Speed', 'dexterity'),
                'help' => esc_html__('', 'dexterity'),
                'choices' => array(
                    '0' => esc_html__('0', 'dexterity'),
                    '0.1' => esc_html__('0.1', 'dexterity'),
                    '0.2' => esc_html__('0.2', 'dexterity'),
                    '0.3' => esc_html__('0.3', 'dexterity'),
                    '0.4' => esc_html__('0.4', 'dexterity'),
                    '0.5' => esc_html__('0.5', 'dexterity'),
                    '0.6' => esc_html__('0.6', 'dexterity'),
                    '0.7' => esc_html__('0.7', 'dexterity'),
                    '0.8' => esc_html__('0.8', 'dexterity'),
                    '0.9' => esc_html__('0.9', 'dexterity'),
                    '1.0' => esc_html__('1.0', 'dexterity'),
                ),
            ),
          
        )
    ),
	'sidebars' => array(
	    'type' => 'tab',
        'title' => esc_html__('Sidebar', 'dexterity'),
        'options' => array(
			'sidebar' => array(
			'type'         => 'multi-picker',
			'label'        => false,
			'desc'         => false,
			'value' 		=> array('gadget' => 'full'),
			'picker'       => array(
				'gadget' => array(
					'label'   => esc_html__( 'Section Sidebar', 'dexterity' ),
					'type'    => 'image-picker',
					'choices' => array(
						'full'  => get_template_directory_uri() . '/images/sidebars/full.png',
						'left'  => get_template_directory_uri() . '/images/sidebars/left.png',
						'right'  => get_template_directory_uri() . '/images/sidebars/right.png',
					)
				)
			),
			'choices'      => array(
				'full'  => array(),
				'left'  => array(
					'left_sidebar' => array(
						'type' => 'select',
						'value' => '',
						'attr' => array(),
						'label' => esc_html__('Select Sidebar', 'dexterity'),
						'desc' => esc_html__('Select Left Sidebar', 'dexterity'),
						'help' => esc_html__('', 'dexterity'),
						'choices' => dexterity_get_registered_sidebars(),
					),
				),
				'right'  => array(
					'right_sidebar' => array(
						'type' => 'select',
						'value' => '',
						'attr' => array(),
						'label' => esc_html__('Select Sidebar', 'dexterity'),
						'desc' => esc_html__('Select Right Sidebar', 'dexterity'),
						'help' => esc_html__('', 'dexterity'),
						'choices' => dexterity_get_registered_sidebars(),
					),
				),
			)
		)
		)		
	),
);
