<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
?>
<div class="sc-services">
    <div class="col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
        <div class="tg-section-head">
            <?php if (isset($atts['heading']) && !empty($atts['heading'])) { ?>
                <div class="tg-theme-heading">
                    <h2><?php echo esc_attr($atts['heading']); ?></h2>
                </div>
            <?php } ?>
            <?php if (isset($atts['main_description']) && !empty($atts['main_description'])) { ?>
                <div class="tg-description">
                    <p><?php echo force_balance_tags($atts['main_description']); ?></p>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="tg-servicesarea tg-haslayout">
        <div class="col-md-8 col-sm-12 col-xs-12">
            <?php
            foreach ($atts['services_popup'] as $services) {
                $link = '#';
				$image_position = 'pull-left';
                $description = 'pul-right';
				
                if (isset($services['link']) && !empty($services['link'])) {
                    $link = $services['link'];
                }
				
				
                if ($services['image-posiion'] === 'right') {
                    $image_position = 'pull-right';
                    $description = 'pul-left';
                }
				
                if ($services['image-posiion'] === 'left') {
                    $image_position = 'pull-left';
                    $description = 'pul-right';
                }
				
				$content_div  = 'col-sm-12 col-xs-12';
				$image_div	= 'col-sm-6 col-xs-6';
                ?>
                <div class="tg-services">
                    <div class="tg-service no-gutters">
                        <?php 
							if (isset($services['image']['url']) && !empty($services['image']['url'])) {
							$content_div  = 'col-sm-6 col-xs-6';
							?>
                            <div class="<?php echo esc_attr( $image_div );?> <?php echo esc_attr($image_position); ?>">
                                <figure>
                                    <img src="<?php echo esc_url($services['image']['url']); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
                                    <figcaption class="tg-img-hover">
                                        <div class="tg-box">
                                            <a class="tg-detail-link" href="<?php echo esc_url($link); ?>"><i class="fa fa-angle-right"></i></a>
                                        </div>
                                    </figcaption>
                                </figure>
                             </div>
                        <?php }?>
                        <div class="<?php echo esc_attr( $content_div );?> <?php echo esc_attr($description); ?>">
                            <div class="tg-content">
                                <div class="tg-box">
                                    <div class="tg-head">
                                        <?php if (isset($services['services_icon']) && !empty($services['services_icon'])) {?>
                                        	<i class="<?php echo esc_attr($services['services_icon']); ?>"></i>
                                        <?php }?>
                                        <?php if (isset($services['title']) && !empty($services['title'])) { ?>
                                            <div class="tg-heading-border">
                                                <h3><a href="<?php echo esc_attr($services['title']); ?>"><?php echo esc_attr($services['title']); ?></a></h3>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <?php if (isset($services['description']) && !empty($services['description'])) { ?>
                                        <div class="tg-description">
                                            <p><?php echo esc_attr($services['description']); ?></p>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php
        $main_image = $atts['main_image']['url'];
        if (isset($main_image) && !empty($main_image)) {
            ?>
            <div class="col-md-4 hidden-sm hidden-xs">
                <figure>
                    <img src="<?php echo esc_url($main_image); ?>" alt="<?php the_title(); ?>">
                </figure>
            </div>
        <?php } ?>
    </div>
</div>