<?php
if (!defined('FW'))
    die('Forbidden');
/**
 * @var $atts
 */
$uni_flag = fw_unique_increment();
?>
<div class="sc-tabs">
	<div class="tg-faq-accorion tg-haslayout">
		<div class="panel-group" id="accordion-<?php echo esc_attr($uni_flag); ?>" role="tablist" aria-multiselectable="true">
			<?php
			if (isset($atts['tabs'])) {
				$counter	= 0;
				$collapse_in = 'in';
				$collapse_active = 'active';
				foreach ($atts['tabs'] as $tabs) {
					$tab_slug = fw_unique_increment();
					$counter++;
					?>
					<div class="panel panel-default <?php echo esc_attr($collapse_active); ?> <?php echo esc_attr($collapse_in); ?>">
						<?php if (isset($tabs['tab_title']) && !empty($tabs['tab_title'])) { ?>
							<div class="panel-heading" role="tab" id="heading-<?php echo intval( $counter );?>">
								<h4 class="panel-title">
									<a role="button" data-toggle="collapse" data-parent="#accordion-<?php echo esc_attr($uni_flag); ?>" href="#tab-<?php echo esc_attr($tab_slug); ?>" aria-expanded="true"><?php echo esc_attr($tabs['tab_title']); ?></a>
								</h4>
							</div>
						<?php } ?>
						<div id="tab-<?php echo esc_attr($tab_slug); ?>" class="panel-collapse collapse <?php echo esc_attr($collapse_in); ?>" role="tabpanel" aria-labelledby="heading-<?php echo intval( $counter );?>">
							<div class="panel-body">
								<?php if (isset($tabs['tab_image']['url']) && !empty($tabs['tab_image']['url'])) { ?>
									<figure class="tg-faqimg">
										<img src="<?php echo esc_url($tabs['tab_image']['url']); ?>" alt="<?php the_title(); ?>">
									</figure>
								<?php } ?>
								<?php if (isset($tabs['tab_content']) && !empty($tabs['tab_content'])) { ?>
									<div class="tg-description">
										<?php echo force_balance_tags($tabs['tab_content']); ?>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
					<?php
					$collapse_in = '';
					$collapse_active = '';
				}//endforeach
			} //endif  
			?>
		</div>
	</div>
</div>