<?php
if (!defined('FW')) {
    die('Forbidden');
}
/**
 * @var $atts
 */
$uni_flag = fw_unique_increment();
$teams = $atts['add_team_person'];
dexterity_init_owl_script();
?>
<?php if (isset($atts['add_team_person'])) { ?>
    <div class="sc-team">
        <div id="tg-team-slider-<?php echo esc_attr($uni_flag); ?>" class="tg-team-slider tg-team-members">
            <?php foreach ($teams as $team) { ?>
                <div class="item">
                    <?php foreach ($team['team_member'] as $team_member) { ?>
                        <div class="col-sm-6 col-xs-6 tg-teamwidth">
                            <div class="tg-member">
                                <figure>
                                    <img src="<?php echo esc_url($team_member['avatar']['url']); ?>" alt="<?php the_title(); ?>">
                                    <figcaption class="tg-img-hover">
                                        <div class="tg-box tg-displayblock">
                                            <div class="tg-heading-border">
                                                <?php if (isset($team_member['designation']) && !empty($team_member['designation'])) { ?>
                                                    <span class="tg-designation"><?php echo (esc_attr($team_member['designation'])); ?></span>
                                                <?php } ?>
                                                <?php
                                                if (isset($team_member['name']) && !empty($team_member['name'])) {
                                                    if (isset($team_member['member_link']) && !empty($team_member['member_link'])) {
                                                        $member_link = $team_member['member_link'];
                                                    }
                                                    ?>
                                                    <h3><a href="<?php echo esc_url($member_link); ?>"><?php echo (esc_attr($team_member['name'])); ?></a></h3>
                                                <?php } ?>
                                            </div>
                                            <ul class="tg-socialicons tg-large">
                                                <?php
                                                foreach ($team_member['social_icons'] as $socials) {
                                                    if (!empty($socials['icon'])) {
                                                        ?>
                                                        <li>
                                                            <a href="<?php echo esc_attr($socials['url']); ?>"><i class="<?php echo esc_attr($socials['icon']); ?>"></i></a>
                                                        </li>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </ul>
                                        </div>
                                    </figcaption>
                                </figure>
                            </div>
                        </div> 
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
        <script>
            /* -------------------------------------
             HOME SLIDER
             -------------------------------------- */
            jQuery(document).ready(function (e) {
                jQuery("#tg-team-slider-<?php echo esc_js($uni_flag) ?>").owlCarousel({
                    autoPlay: true,
                    slideSpeed: 300,
                    paginationSpeed: 400,
                    singleItem: true,
                    navigation: false,
                    navigationText: [
                        "<i class='fa fa-angle-left'></i>",
                        "<i class='fa fa-angle-right'></i>"
                    ]
                });
            });
        </script>
    </div>
<?php } ?>
