<?php

if (!defined('FW')) {
    die('Forbidden');
}


$options = array(
    'api_settings' => array(
        'type' => 'tab',
        'title' => esc_html__('Api Settings', 'dexterity'),
        'options' => array(
            'google' => array(
                'title' => esc_html__('Google', 'dexterity'),
                'type' => 'tab',
                'options' => array(
                    'google_key' => array(
                        'type' => 'text',
                        'value' => '',
                        'label' => esc_html__('Google Map Key', 'dexterity'),
						'desc' => wp_kses( __( 'Enter google map key here. It will be used for google maps. Get and Api key From <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank"> Get API KEY </a>', 'dexterity' ),array(
																		'a' => array(
																			'href' => array(),
																			'title' => array()
																		),
																		'br' => array(),
																		'em' => array(),
																		'strong' => array(),
																	)),
                    ),
                )
            ),
			'flickr' => array(
                'title' => esc_html__('Flickr', 'dexterity'),
                'type' => 'tab',
                'options' => array(
                    'flickr_key' => array(
                        'type' => 'text',
                        'value' => '',
                        'label' => esc_html__('Flickr Key', 'dexterity'),
                        'desc' => esc_html__('Enter flickr key here.', 'dexterity'),
                    ),
                    'flickr_secret' => array(
                        'type' => 'text',
                        'value' => '',
                        'label' => esc_html__('Flickr Secret', 'dexterity'),
                        'desc' => esc_html__('Enter your flickr secret here.', 'dexterity'),
                    ),
                )
            ),
            'mailchimp' => array(
                'title' => esc_html__('Mail Chimp', 'dexterity'),
                'type' => 'tab',
                'options' => array(
                    'mailchimp_key' => array(
                        'type' => 'text',
                        'value' => 'b1c640ffabcea48f48530987ffdae147-us11',
                        'label' => esc_html__('MailChimp Key', 'dexterity'),
                        'desc' => esc_html__('Enter your MailChimp Key Here. Default: b1c640ffabcea48f48530987ffdae147-us11', 'dexterity'),
                    ),
                    'mailchimp_list' => array(
                        'type' => 'select',
                        'label' => esc_html__('MailChimp List', 'dexterity'),
                        'choices' => dexterity_mailchimp_list(),
                    )
                )
            ),
        )
    )
);


