<?php
/**
 * Email Helper For Theme
 *
 * Long Description.
 *
 * @since    1.0.0
 */
if( ! class_exists( 'DexterityProcessEmail' ) ) {
	class DexterityProcessEmail{
		
		public function __construct(){
			// Do Something
		}
		
		/**
		 * Get Email Header
		 *
		 * Return email header html
		 *
		 * @since    1.0.0
		 */
		 public function prepare_email_headers( $name = '' ) {
			global $current_user;
			ob_start();
			?>
            <table class="body-wrap" bgcolor="#f6f6f6" style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; width: 100%; margin: 0; padding: 20px;">
  <tr style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;">
    <td style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;"></td>
    <td class="container" bgcolor="#FFFFFF" style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; clear: both !important; display: block !important; max-width: 600px !important; Margin: 0 auto; padding: 20px; border: 1px solid #f0f0f0;"><!-- content -->
      
      <div class="content" style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; display: block; max-width: 600px; margin: 0 auto; padding: 0;">
        <table style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; width: 100%; margin: 0; padding: 0;">
          <tr style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;">
            <td style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;"><p style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><?php esc_html_e('Hi','dexterity');?><?php echo esc_attr( $name );?>,</p>
            <?php
			return ob_get_clean();	
		 }
	
		/**
		 * Get Email Footer
		 *
		 * Return email footer html
		 *
		 * @since    1.0.0
		 */
		 public function prepare_email_footers( $params ='' ) {
			global $current_user;
			ob_start();
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			?>
          <p style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><?php esc_html_e('Thanks, have a lovely day.','dexterity');?></p>
          <p style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><?php echo date('Y');?><?php esc_html_e(' | All Rights Reserved','dexterity');?> <a href="<?php echo esc_url(home_url('/')); ?>" style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; color: #348eda; margin: 0; padding: 0;"><?php echo esc_attr( $blogname );?></a></p></td>
                  </tr>
                </table>
              </div>
          
              <!-- /content --></td>
              <td style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;"></td>
              </tr>
            </table>
            <!-- /body --><!-- footer -->
            <table class="footer-wrap" style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; clear: both !important; width: 100%; margin: 0; padding: 0;">
              <tr style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;">
                <td style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;"></td>
                <td style="font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;"></td>
              </tr>
            </table>

            <?php
			return ob_get_clean();
		 }
		
		
		/**
		 * Online Appointment
		 *
		 * @since    1.0.0
		 */
		 public function process_appointment_email( $params = '' ) {
			global $current_user;
			extract( $params );
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			$admin_email	= get_option( 'admin_email' ,'info@themographics.com' );
			$subject  = esc_html__('Appointment Schedule at ','dexterity')." (" . $blogname . ")";	
			
			$email_headers = "From: no-reply <info@no-reply.com>\r\n";
			$email_headers .= "Reply-To: no-reply <info@no-reply.com>\r\n";
			$email_headers .= "CC: ".$admin_email."\r\n";
			$email_headers .= "MIME-Version: 1.0\r\n";
			$email_headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

			
			$attachments	  = '';
			$body			 = '';
			$body			.= $this->prepare_email_headers();
			$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;">'.esc_html__('Thank you for your order. We have received your order. Soon we will get back to you. Your order number is given below.','dexterity').'</p>';
			$body			.= '<table class="btn-primary" cellpadding="0" cellspacing="0" border="0" style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; width: auto !important; Margin: 0 0 10px; padding: 0;"><tr style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;">
<td style="font-family: \'Helvetica Neue\', Helvetica, Arial, \'Lucida Grande\', sans-serif; font-size: 14px; line-height: 1.6em; border-radius: 25px; text-align: center; vertical-align: top; background: #348eda; margin: 0; padding: 0;" align="center" bgcolor="#348eda" valign="top">
                  <a href="javascript:;" style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 2; color: #ffffff; border-radius: 25px; display: inline-block; cursor: pointer; font-weight: bold; text-decoration: none; background: #348eda; margin: 0; padding: 0; border-color: #348eda; border-style: solid; border-width: 10px 20px;">'.$appointment_no.'</a>
                </td>
              </tr></table>';
			
			  $body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;">'.esc_html__('Other information is given below: ','dexterity').'</p>';
			  
			  if( !empty( $apt_services ) && is_array( $apt_services ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Services Needed: ','dexterity').'</strong>';
					
					$services	= array();
					foreach($apt_services as $key => $value ){
						$services[$key]	= get_the_title( $value );
					}
					$body			.= implode(',',$services);
					$body			.= '</p>';
			  }
			  
			  if( !empty( $apt_name ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Your Name: ','dexterity').'</strong>'.$apt_name.'</p>';
			  }
			  
			  if( !empty( $apt_email ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Your Email: ','dexterity').'</strong>'.$apt_email.'</p>';
			  }
			  
			  if( !empty( $apt_phone ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Contact: ','dexterity').'</strong>'.$apt_phone.'</p>';
			  }
			  
			  
			  if( !empty( $apt_date ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Appointment Date ','dexterity').'</strong>'.$apt_date.'</p>';
			  }
			  
			  if( !empty( $apt_message ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Message: ','dexterity').'</strong>'.$apt_message.'</p>';
			  }
			  
			  
			  
			$body 			.= $this->prepare_email_footers();
			
			mail($apt_email, $subject, $body, $email_headers);
		 }
		 
		/**
		 * Contact Us Form
		 *
		 * @since    1.0.0
		 */
		 public function process_contact_email( $params = '' ) {
			global $current_user;
			extract( $params );
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			$admin_email	= get_option( 'admin_email' ,'info@themographics.com' );
			$subject  = esc_html__('Contact Form','dexterity')." (" . $blogname . ")";	
			
			$email_headers = "From: no-reply <info@no-reply.com>\r\n";
			$email_headers .= "Reply-To: no-reply <info@no-reply.com>\r\n";
			$email_headers .= "CC: ".$admin_email."\r\n";
			$email_headers .= "MIME-Version: 1.0\r\n";
			$email_headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

			
			$attachments	  = '';
			$body			 = '';
			$body			.= $this->prepare_email_headers();
			$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;">'.esc_html__('A site visitor has left message. detail is given below.','dexterity').'</p>';
			$body			.= '<table class="btn-primary" cellpadding="0" cellspacing="0" border="0" style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; width: auto !important; Margin: 0 0 10px; padding: 0;"><tr style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 1.6em; margin: 0; padding: 0;">
<td style="font-family: \'Helvetica Neue\', Helvetica, Arial, \'Lucida Grande\', sans-serif; font-size: 14px; line-height: 1.6em; border-radius: 25px; text-align: center; vertical-align: top; background: #348eda; margin: 0; padding: 0;" align="center" bgcolor="#348eda" valign="top">
                </td>
              </tr></table>';

			  
			  if( !empty( $username ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Name: ','dexterity').'</strong>'.$username.'</p>';
			  }
			  
			  if( !empty( $subject ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Subject: ','dexterity').'</strong>'.$subject.'</p>';
			  }
			  
			  if( !empty( $email ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Email Address: ','dexterity').'</strong>'.$email.'</p>';
			  }
			  
			  
			  if( !empty( $website ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Website: ','dexterity').'</strong>'.$website.'</p>';
			  }
			  
			  if( !empty( $userphone ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Contact: ','dexterity').'</strong>'.$userphone.'</p>';
			  }
			  
			  if( !empty( $apt_message ) ) {
			  		$body			.= ' <p style="font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.6em; font-weight: normal; margin: 0 0 10px; padding: 0;"><strong>'.esc_html__('Message: ','dexterity').'</strong>'.$apt_message.'</p>';
			  }
			  
			  
			  
			$body 			.= $this->prepare_email_footers();
			
			mail($apt_email, $subject, $body, $email_headers);
		 }

	}
	new DexterityProcessEmail();
}